<?php

namespace App\Traits;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\StudentAdmission\GlobalSiteAdmissionPaymentHistory;
use App\Traits\Site\Payment\StudentSonaliPayTransactionTrait;
use Error;
use Exception;
use Request;

trait TransactionCheckApiTrait
{
    use StudentSonaliPayTransactionTrait;
    /*
      request----------------------
    ==>common Req==> "transaction_id", "bearer_type", "bearer_id", "edu_user_name"
    1.$req_data =>
    1..1-->sure_cash==> "partner_code","user_name","password"

    2.$vendor =>"sure_cash" ,
    */

    public function verifyOnlineTransId($req_data, $vendor = 'cellfin')
    {
      //  dd($vendor);

        try {

            $vendor_found = false;
            $edu_user_name = $req_data['edu_user_name'] ?? "";


            $response = [
                "statusCode" => 0,//main key-value
                //-----always key-value
                "status" => null,
                "description" => null,
                //-----------------
                "amount" => 0.0,
                "note1" => null,
                "transactionId" => null,
                "txnDate" => null,
                "invoice_number" => null,
                "customerId" => null,
                "customerMobileNumber" => null,
                "partnerCode" => null,
                "partnerAccountNo" => null,
            ];
//=========================Call Function=================================
            if($vendor=='cellfin'){
                $res = $this->cellFin($req_data);
               // dd($res);

                if($res){

                    if($res['status'] == 'APPROVED'){
                        $response=[
                            'invoiceNo'=>$res['invoiceNo'],
                            'token'=>'',
                            'trId'=>$res['trId'],
                            'status'=>$res['status'],
                            'date_time'=>$res['date_time'],
                            'tr_amount'=>$res['tr_amount'],
                            'cr_amount'=>$res['cr_amount'],
                            'source_of_fund'=>'CELLFIN',
                            'statusCode'=>200,
                            'description'=>'success',
                        ];
                    }else{
                        $response=[
                            'invoiceNo'=>'100',
                            'token'=>'',
                            'trId'=>'',
                            'status'=>'',
                            'date_time'=>'00/00/0000 00:00 PM',
                            'tr_amount'=>'',
                            'cr_amount'=>'',
                            'source_of_fund'=>'',
                            'statusCode'=>0,
                            'description'=>'error',

                            // 'invoiceNo'=>'10028',
                            // 'token'=>'3454345535',
                            // 'trId'=>'3535353535',
                            // 'status'=>'success',
                            // 'date_time'=>'13/07/2024 10:29 PM',
                            // 'tr_amount'=>'5010',
                            // 'cr_amount'=>'5000',
                            // 'source_of_fund'=>'CELLFIN',
                            // 'statusCode'=>200,
                            // 'description'=>'error',
                        ];
                    }
                }else{
                    $response=[
                        'invoiceNo'=>'100',
                        'token'=>'',
                        'trId'=>'',
                        'status'=>'',
                        'date_time'=>'00/00/0000 00:00 PM',
                        'tr_amount'=>'',
                        'cr_amount'=>'',
                        'source_of_fund'=>'',
                        'statusCode'=>0,
                        'description'=>'error',
                    ];
                }

            }else if($vendor=='sonali_pay'){
               
               return $response = $this->sonaliPay($req_data);
            }else{
                $res = $this->sureCash($req_data);
                if($res['transactionId'] == $req_data['transaction_id'] ){
                    return $res;
                }else{
                    return "error";
                }
            }


            return $response;

        } catch (Exception $exception) {

        }


    }


    private function sureCash($req_data)
    {

        try {

            $eduUserName = $req_data['edu_user_name'] ?? "";
            $partnerCode = $req_data['partner_code'] ?? "";
            $transactionId = $req_data['transaction_id'] ?? "";
            $user_name = $req_data['user_name'] ?? "";
            $password = $req_data['password'] ?? "";
            // $mobileNumber = "01XXXXXXXXX";

            $credentials = base64_encode($user_name . ":" . $password);

            $headr = array();
            $headr[] = 'Accept: application/json';
            $headr[] = 'Content-type: application/json';
            $headr[] = 'Authorization: basic ' . $credentials;

            $ch = curl_init();
            //https://api.surecashbd.com/api/payment/status/byTransactionID/shortcode/TxnID
           // curl_setopt($ch, CURLOPT_URL, "http://sandbox.surecash.net:8080/surecash-payment-api-sandbox/api/payment/status/" . $partnerCode . "/" . $transactionId);
            curl_setopt($ch, CURLOPT_URL, "https://api.surecashbd.com/api/payment/status/byTransactionID/" . $partnerCode . "/" . $transactionId);

            //curl_setopt($ch, CURLOPT_POST, 1);
            //curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($requestBody));
            curl_setopt($ch, CURLOPT_USERPWD, $credentials);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headr);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 1000);
            $response = curl_exec($ch);
            curl_close($ch);
            $resArray = json_decode($response, true);

              // dd($resArray);

            return $resArray;
        } catch (Exception $exception) {

        }
    }

    private function cellFin($req_data)
    {

        try {

            $random = $req_data['transaction_id'] ?? "";
        //    $userId = $req_data['user_name'] ?? "";
        //    $myPassword = $req_data['password'] ?? "";

            $userId = 'EduWorld'; // get by cellfin
            $myPassword = '3dfafa0c6e8eab2612a1ce97cbdabadac88b469f92da8efdf8dc45860ac4c434'; // get by cellfin

            $operation = "STATUS";
            $invoice_no = $req_data['invoice_no'] ?? "";
            $password= hash("sha512",$myPassword.$random.$invoice_no);

            $data = [
                "userId" => $userId,
                "password" => $password,
                "operation" => $operation,
                "random" => $random,
                "invoiceNo" => $invoice_no,
            ];


            /////////// for test
            // $data = [
            //     "userId" => 'DeshUniversal',
            //     "password" => 'f2625cd5fcf3ab69a6efd798a8654ee4900663d02db22762320103a6573571511354683c0e8bc8c6b1589be7a4af70e085b6543db935c2bc3f588d1b691b4690',
            //     "operation" => 'STATUS',
            //     "random" => '8023102500016516',
            //     "invoiceNo" => '9cb292a2-29a0-4e0c-80e0-9d2a2a6db15b',
            // ];

            $url = "https://ewallet.islamibankbd.com/getTrxInfo.do";
            $ch = curl_init($url);
            $jsonData = json_encode($data);

            $headers = [
                'Content-Type: application/json',
                'Content-Length: ' . strlen($jsonData)
            ];

            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 1000);

            $response = curl_exec($ch);
            curl_close($ch);
            $resArray = json_decode($response, true);
            return $resArray;


        } catch (Exception $exception) {

        }
    }

    private function sonaliPay($req_data){
       // dd($req_data);

        $paymentHistory = GlobalSiteAdmissionPaymentHistory::where('site_id',$req_data['site_id'])
            ->where('transaction_id',$req_data['transaction_id'])
            ->first();

        if(!$paymentHistory){
            return ['Status'=>'410','Message'=>'Payment history not found!'];
        }

        $data=[
            'Token'=>$paymentHistory->transaction_token,
            'site_id'=>$req_data['site_id'],
            'username'=>$paymentHistory->site_student_admission_board_approve_id,
        ];

      
      return $this->verifyTransectionSonaliPayToken('site-admission',$data);


    }
}

