<?php

namespace App\Traits;

use Carbon\Carbon;
use DateInterval;
use DateTime;
use Exception;
use Log;

trait TimeRelatedFunctionTrait
{


    private function addMinutesToTime($time, $plusMinutes)
    {

        try {
            $org_time = $time;
            $min_plus = $plusMinutes;


            $time1 = DateTime::createFromFormat('G:i:s', $org_time);
            $time1->add(new DateInterval('PT' . ((integer)$min_plus) . 'M'));
            $newTime = $time1->format('G:i:s');

            // dd($newTime);
            return $newTime;


        } catch (Exception $exception) {

            return $time;

        }

    }


    private function minusMinutesFromTime($time, $minutes)
    {

        try {
            $org_time = $time;
            $min_minus = $minutes;


            //   $date = date("Y-m-d H:i:s");
            $time = strtotime($org_time);
            $time = $time - ($min_minus * 60);
            $newTime = date("H:i:s", $time);//10:00:00


            return $newTime;


        } catch (Exception $exception) {

            Log::info('error in TimeRelatedFunctionTrait: minusMinutesToTime() ' . $exception->getMessage());

            return $time;

        }

    }

    private function checkStIsLate($access_time1, $shift_details)
    {

        $late = false;
        $in_time = strtotime($shift_details->in_time);
        $access_time = strtotime($access_time1);


        if ($access_time > $in_time) {
            $late = true;
        }

        //check shift details grace
        if ($shift_details->in_time_grace) {

            $grace_min = $shift_details->in_time_grace;
            $final_in_time = date("H:i:s", strtotime('+' . $grace_min . ' minutes', $in_time));

            // dd($access_time1,$final_in_time, $grace_min);

            if ($access_time1 <= $final_in_time) {
                $late = false;
            }
        }
        return $late;

    }

    public function getDateInDifferentLanguage($date, $lang = 'en')
    {
        $date = $date ?? Carbon::now()->toDateString();
        $currentDate = date("F j, Y", strtotime($date));

        if ($lang == 'en') {
            return $currentDate;
        }
        $engDATE = array('1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
        $bangDATE = array('১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯', '০', 'জানুয়ারী', 'ফেব্রুয়ারী', 'মার্চ', 'এপ্রিল', 'মে', 'জুন', 'জুলাই', 'আগস্ট', 'সেপ্টেম্বর', 'অক্টোবর', 'নভেম্বর', 'ডিসেম্বর');
        $convertedDATE = str_replace($engDATE, $bangDATE, $currentDate);
        return $convertedDATE;
    }

    public function getWeekdayDateInDifferentLanguage($date, $lang = 'en')
    {
        $date = $date ?? Carbon::now()->toDateString();
        $currentDate = date("l, F j, Y", strtotime($date));
        if ($lang == 'en') {
            return $currentDate;
        }
        $engDATE = array('1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December', 'Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
        $bangDATE = array('১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯', '০', 'জানুয়ারী', 'ফেব্রুয়ারী', 'মার্চ', 'এপ্রিল', 'মে', 'জুন', 'জুলাই', 'আগস্ট', 'সেপ্টেম্বর', 'অক্টোবর', 'নভেম্বর', 'ডিসেম্বর', 'শনিবার', 'রবিবার', 'সোমবার', 'মঙ্গলবার', 'বুধবার', 'বৃহস্পতিবার', 'শুক্রবার');
        $convertedDATE = str_replace($engDATE, $bangDATE, $currentDate);
        return $convertedDATE;

    }

}