<?php

namespace App\Traits\Site\Payment;


use App\Http\Middleware\EncryptCookies;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Edu\PaymentGateway\EduPaymentGateway;
use App\Models\Edu\SitePayment\EduInvoicePayment;
use App\Models\Edu\SitePayment\SiteInvoice;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Invoice\InvoiceHistoryTrait;
use Carbon\Carbon;
use phpseclib\Crypt\RSA;
use Request;
use Illuminate\Support\Facades\File;
use Auth;

trait SiteBkashTransactionTrait
{
    use InvoiceHistoryTrait;

    public function token()
    {
        session_start();


        $request_token = $this->bkash_Get_Token();
        $idtoken=$request_token['id_token'];

        $_SESSION['token']=$idtoken;
//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);
        //=================testing===========

        //===============================

//        $array = $this->getConfigFile();
//        $array['token']=$idtoken;
//
//        $newJsonString = json_encode($array);
//        file_put_contents('config.json',$newJsonString);
//        File::put(storage_path().'/app/public/config.json',$newJsonString);

        echo $idtoken;
    }

    protected function bkash_Get_Token(){

//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);

        //============database test=============
        $array = EduPaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();

        $post_token=array(
            'app_key'=>$array->app_key,
            'app_secret'=>$array->app_secret
        );

        $url=curl_init($array->token_url);
//        return $array->token_url;
        $proxy = $array->proxy;
        $posttoken=json_encode($post_token);


        $header=array(
            'Content-Type:application/json',
            'password:'.$array->password,
            'username:'.$array->user_name
        );
//        return $header;

       //==========file test=============

//        $array = $this->getConfigFile();
//
////        return $array;
//
//        $post_token=array(
//            'app_key'=>$array["app_key"],
//            'app_secret'=>$array["app_secret"]
//        );
//
//
////        return $post_token;
////        return $array["tokenURL"];
//        $url=curl_init($array["tokenURL"]);
//
//        $proxy = $array["proxy"];
//        $posttoken=json_encode($post_token);
//
//        $header=array(
//            'Content-Type:application/json',
//            'password:'.$array["password"],
//            'username:'.$array["username"]
//        );
////        return $header;
//


        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_POSTFIELDS, $posttoken);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
        //curl_setopt($url, CURLOPT_PROXY, $proxy);

        $resultdata=curl_exec($url);
        curl_close($url);
//        return $resultdata;

        return json_decode($resultdata, true);
//        return $resultdata;
    }

    public function getConfigFile()
    {
        $path = storage_path()."/app/public/config.json";
        return json_decode(file_get_contents($path),true);
    }
    public function createBkashEduPayment()
    {
        session_start();
//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);
        $array = EduPaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();

        $amount = $_GET['amount'];
        $invoice = $_GET['invoice']; // must be unique
        $intent = "sale";
        $proxy = $array->proxy;
        $createpaybody=array('amount'=>$amount, 'currency'=>'BDT', 'merchantInvoiceNumber'=>$invoice,'intent'=>$intent);
        $url = curl_init($array->create_url);

        $createpaybodyx = json_encode($createpaybody);

        $header=array(
            'Content-Type:application/json',
            'authorization:'.$array->token,
            'x-app-key:'.$array->app_key
        );



//        $array = $this->getConfigFile();
//        $amount = $_GET['amount'];
//        $invoice = $_GET['invoice']; // must be unique
//        $intent = "sale";
//        $proxy = $array["proxy"];
//        $createpaybody=array('amount'=>$amount, 'currency'=>'BDT', 'merchantInvoiceNumber'=>$invoice,'intent'=>$intent);
//        $url = curl_init($array["createURL"]);
//
//        $createpaybodyx = json_encode($createpaybody);
//
//        $header=array(
//            'Content-Type:application/json',
//            'authorization:'.$array["token"],
//            'x-app-key:'.$array["app_key"]
//        );

        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_POSTFIELDS, $createpaybodyx);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
        //curl_setopt($url, CURLOPT_PROXY, $proxy);

        $resultdata = curl_exec($url);
        curl_close($url);
        echo $resultdata;

    }
    public function executePayment($data)
    {
        session_start();
//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);
        $array = EduPaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();

        $paymentID = $_GET['paymentID'];
        $proxy = $array["proxy"];

        $url = curl_init($array->execute_url.$paymentID);

        $header=array(
            'Content-Type:application/json',
            'authorization:'.$array->token,
            'x-app-key:'.$array->app_key
        );


        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);

        $resultdatax=curl_exec($url);
        curl_close($url);
        $this->updateOrderStatus($resultdatax, $array);
        echo $resultdatax;

    }
    protected function updateOrderStatus($resultdatax, $array)
    {
        $resultdatax = json_decode($resultdatax);
        $resultdatax = json_encode($resultdatax);
        $resultdatax = json_decode($resultdatax);
        $paymentID = $resultdatax->paymentID;
//        dd($resultdatax->paymentID) ;

        if($resultdatax && $paymentID && $resultdatax->transactionStatus == 'Completed'){
            $trxID = $resultdatax->trxID;
            $createTime = $resultdatax->createTime;
            $transactionStatus = $resultdatax->transactionStatus;
            $amount = $resultdatax->amount;
            $currency = $resultdatax->currency;

            $merchantInvoiceNumber = $resultdatax->merchantInvoiceNumber;
            if($merchantInvoiceNumber){
                $payment_type = 'bkash';
                $transaction_by_id = false;


                //=========================edu payment table update===================

                $current_date_time =  Carbon::today();
                $payment_date = $current_date_time;
                $paymentID = $paymentID;

                $invoice = new SiteInvoice();

                $the_invoice = $invoice->where('invoice_no', $merchantInvoiceNumber)->first();

                $invoicePayment = new EduInvoicePayment();


                $invoicePayment->invoice_id = $the_invoice->id;
                $invoicePayment->account_code = 'cash';
                $invoicePayment->payment_method = 'bkash';
                $invoicePayment->reference_no = $trxID;
                $invoicePayment->payment_id = $paymentID;
                $invoicePayment->paid_amount = $amount;
                $invoicePayment->status_code = 'approved';
                $invoicePayment->payment_date = $payment_date;
                $invoicePayment->online_payment_create_date_time = $createTime;
                $invoicePayment->site_id = $the_invoice->site_id;
                $invoicePayment->payment_by = Auth::user()->id;
                $invoicePayment->save();

//                $the_invoice = $this->invoice->findOrfail($request->invoice_id);


                $this->createHistory($the_invoice->id, 'approved', 'Invoice:' . $the_invoice->invoice_no . ' Payment Taken: ' . $amount);

                $the_invoice->status_code = 'partial';
                $this->createHistory($the_invoice->id, 'draft', 'Invoice:' . $the_invoice->invoice_no . ' Status Changed to Partial');


                if ($the_invoice->amount_due == 0) {
                    $the_invoice->status_code = 'paid';
                    $this->createHistory($the_invoice->id, 'draft', 'Invoice:' . $the_invoice->invoice_no . ' Status Changed to Paid');
                }
                $the_invoice->save();



                //===================Log Start====================


                $return_data = json_encode($resultdatax, true);
                $issue = new    IssueDetail();
                $issue->issue_type = 'transaction:site-student';

                $issue->bearer_type = 'site';
                $issue->bearer_id = \Session::get('SITE_ID');
                $issue->username ="";
                $issue->ip_address = request()->ip();
                $issue->issue_details = $return_data;

                $issue->save();

            }
            return true;
        }
    }

}