<?php

namespace App\Traits\Site\Log;

use App\Models\Site\Log\AuditLog;
use Illuminate\Database\Eloquent\Model;


trait AuditLogTrait
{

    /* public static function bootSearchableTrait()
     {
         static::created(function($item){
             // Index the item
         });
     }*/


    public static function bootAuditLogTrait()
    {

        static::creating(function (Model $model) {
            static::audit('creating', $model);
        });

        static::created(function (Model $model) {
            static::audit('created', $model);
        });

        static::saving(function (Model $model) {
            static::audit('saving', $model);
        });
        static::saved(function (Model $model) {
            static::audit('saved', $model);
        });

        static::updating(function (Model $model) {
            static::audit('updated', $model);
        });

        static::updated(function (Model $model) {
            static::audit('updated', $model);
        });

        static::deleting(function (Model $model) {
            static::audit('deleting', $model);
        });

        static::deleted(function (Model $model) {
            static::audit('deleted', $model);
        });
    }

    // private static function

    private static function audit($description, $model)
    {
        AuditLog::create([
            'description' => $description,
            'subject_id' => $model->id ?? null,
            'subject_type' => get_class($model) ?? null,
            'user_id' => auth()->id() ?? null,
            'properties' => $model ?? null,
            'site_id' => $model->site_id ?? 0,
            'host' => request()->ip() ?? null,
        ]);
    }
}