<?php

namespace App\Traits\Site\Fee;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\SiteInfo;
use App\Traits\SmsFunctionsTrait;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\StudentAdmission\GlobalSiteAdmissionPaymentHistory;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionDeclareOnlineApi;
use App\Traits\Site\Payment\StudentSonaliPayTransactionTrait;
use Carbon\Carbon;
use Exception;

trait AdmissionFeeTrait
{

    use StudentSonaliPayTransactionTrait, SmsFunctionsTrait;

    public function getAdmissionFee2($req_data){

        
        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');

        $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::with('siteStudentAdmissionDeclare')
            ->whereHas('siteStudentAdmissionDeclare')
            ->where('board_roll_number', $req_data['reference_id'])
            ->where('site_id',$req_data['site_id'])
            ->where('second_payment_status',0)
            ->where('admission_status',0)
            ->where('status',1)
            ->first();

        if(!$borad_approve_student){
            return ['message'=>'Data not found!','status'=>'410'];
        }

          //  dd($borad_approve_student);

            $invoiceNo=$borad_approve_student->id+10000;
            $invoiceNo= (string) $invoiceNo;
            $board_roll_number= (string) $borad_approve_student->board_roll_number??'';
            $sum_total=$borad_approve_student->admission_fee+$borad_approve_student->other_fee;
            $total_fee_with_other=$borad_approve_student->total_fee_with_other;

            if($sum_total!=$total_fee_with_other){
                return ['message'=>'Amount not match!','status'=>'410'];
            }

            $vendor=GlobalSiteStudentAdmissionDeclareOnlineApi::where('site_id',$req_data['site_id'])
                ->where('academic_payment_type_key','online')
                ->pluck('vendor');

         //   dd($borad_approve_student);

          //  $board=AcademicBoard::where('name_key',$borad_approve_student)->first()

          $payment_method_keys = GlobalSitePaymentGateway::where('site_id',$req_data['site_id'])
            ->whereIn('academic_payment_method_key',$vendor)
            ->pluck('academic_payment_method_key');

          $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)->where('status',true)->get();

            $data=[
                'status' => '200',
                'message' => 'success',
                'loaded_reference_id' => $req_data['reference_id'],
                'payment_method_list' => $payment_method_list,
                'admission_info'=> [
                    'reference_id'=>$board_roll_number,
                    'date_time' => $dateTime,
                    'shift_name' => $borad_approve_student->shift?$borad_approve_student->shift->shift_name:'',
                    'class_name' => $borad_approve_student->stClass?$borad_approve_student->stClass->class_name:'',
                    'invoice_no' => $invoiceNo,
                    'student_name' => $borad_approve_student->first_name?$borad_approve_student->first_name:'',
                    'father_name' => $borad_approve_student->father_name?$borad_approve_student->father_name:'',
                    'academic_year' => $borad_approve_student->year?$borad_approve_student->year->year_name:'',
                    'board_name' => $borad_approve_student->academicBoard?$borad_approve_student->academicBoard->key_name:'',
                    'total_fee' => $borad_approve_student->total_fee_with_other,
                    'total_in_word' => $this->convertNumberToWord($borad_approve_student->total_fee_with_other),
                    'total_waiver' => '',
                    'fee_list' => [
                       [
                        'head_key'=>'admission_fee',
                        'head_name'=>'Admission Fee',
                        'head_amount'=>$borad_approve_student->admission_fee,
                       ],
                       [
                        'head_key'=>'other_fee',
                        'head_name'=>'Other Fee',
                        'head_amount'=>$borad_approve_student->other_fee,
                       ]
                     ],
                    ]
            ];

            return $data;

    }


    public function gatewayAdmissionPaymentReceive($res_data,$api_res_data,$borad_approve_student,$gateway_key){
      
      
        $site_id=$res_data['site_id'];
        $academic_group_id=$res_data['academic_group_id'];

        $datetime = $res_data['transaction_date'];
        $carbon = Carbon::parse($datetime);

        $tr_date = $carbon->toDateString();    // "2025-04-23"
        $tr_time = $carbon->toTimeString();

                      //==============fine section===================
                     // GlobalSiteAdmissionPaymentHistory
        $check_payment_happend = GlobalSiteAdmissionPaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('site_student_admission_board_approve_id', $borad_approve_student->id)
            ->first();

        if($check_payment_happend){
            return ['status'=>'200','message'=>'Payment already done!'];      
        }

        $borad_approve_student->update(
            [
            'payment_status'=>1,
            'invoice_on'=>$res_data['voucher_no'],
            'payment_date'=>$tr_date,
            'payment_time'=>$tr_time,
            'online_payment_status'=>1,
            'tr_amount'=>$res_data['transaction_amount'],
            'transaction_number'=>$res_data['transaction_id'],
            'bank_name'=>'SPL',
            'paid_by'=>'SonaliPay',
            ]
        );

         //   dd($credit_condition);
            ///

        $gateway_charge=$res_data['transaction_amount']-$res_data['paid_amount'];

        $admission_fee=new GlobalSiteAdmissionPaymentHistory;

        $admission_fee->site_student_admission_board_approve_id=$borad_approve_student->id;
        $admission_fee->invoice_id=$res_data['voucher_no'];
        $admission_fee->transaction_id=$res_data['transaction_id'];
        $admission_fee->transaction_date=$tr_date;
        $admission_fee->transaction_time=$tr_time;
        
        $admission_fee->transaction_token=$res_data['token'];
        $admission_fee->transaction_amount=$res_data['transaction_amount'];
        $admission_fee->gateway_charge=$gateway_charge;
        $admission_fee->total_paid_amount=$res_data['paid_amount'];
        $admission_fee->transaction_gateway=$gateway_key;
        $admission_fee->transaction_mode=$res_data['pay_mode'];
        $admission_fee->transaction_gateway_response=json_encode($api_res_data);
        $admission_fee->credit_info=$res_data['credit_info'];
        $admission_fee->account_setting_info=$res_data['account_setting_info'];
        $admission_fee->site_id=$site_id;
        $admission_fee->academic_group_id=$academic_group_id;
        $admission_fee->status=1;
        $admission_fee->save();


            //=========================sms================================
        $paymentHistoryDetails = GlobalSiteAdmissionPaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_student_admission_board_approve_id', $borad_approve_student->id)
            ->where('status', 1)
            ->first();

        $the_site = SiteInfo::findOrFail($site_id);
    
        if($the_site->admission_fee_paid_sms){

            $payment_date=$res_data['transaction_date'];

            $phone_number =  $borad_approve_student->contact_number;
            $student_name = $borad_approve_student->first_name;
            $roll = $borad_approve_student->board_roll_number;
            $invoice_id = $paymentHistoryDetails->invoice_id;
            $paid_amount = $paymentHistoryDetails->total_paid_amount;
            $transaction_id = $paymentHistoryDetails->transaction_id;
        
            $sms_txt = "Payment Successful";
            $sms_txt .=', '.$student_name;
            $sms_txt .=', '.'Roll:'.$roll;
            $sms_txt .=', '.'Invoice No:'.$invoice_id;
            $sms_txt .=', '.'Paid:'.$paid_amount;
            $sms_txt .=', '.'TrxID :'.$transaction_id;
            $sms_txt .=', '.'Payment Date:'.$payment_date;
            $sms_txt .=', '.'Thanks:' . $the_site->site_alias;

            $tt = $this->sendPaymentSms2($site_id, [$phone_number],$sms_txt );
        
        }

        //======================notification========================
        // dispatch(new GlobalPaymentHistoryJob($paymentHistoryDetails));

        return ['status'=>'200','message'=>'success'];
                
          
    }


    public function sendPaymentSms2($site_id,$numbers,$sms_txt)
    {

        try {
            $type='site';
            $this->sendSmsUsingQueue($numbers, $sms_txt, $type, $site_id);
            return true;

        } catch (Exception $exception) {
            $issue = new IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issue_details = $exception->getMessage();
            $issue->site_id = $site_id;
            $issue->save();

            return false;


        }
    }
 


 
}
