<?php

namespace App\Traits;

use App\Models\Edu\Device\DeviceLog;
use App\Models\Edu\Issue\IssueDetail;
use Carbon\Carbon;
use DB;

trait RequestHandlingWithMachine
{


    public function fetchUnsentLog($s_date = null, $s_time = null, $e_date = null, $e_time = null)
    {

        $start_date = $s_date ?? date('Y-m-d', time());
        $start_time = $s_time ?? date('H:i:s', time());

        $end_date = $e_date ?? $s_date;
        $t = strtotime("+60 minutes", strtotime($start_time));
        $end_time = $e_time ?? date('H:i:s', $t);


        $data = array("operation" => "fetch_unsent_log", "auth_code"
        => "hy6s4fu3fodflkm7e9048mz1pjfku2w");


        $data_pay_load = json_encode($data);
        $api_request = curl_init('https://rumytechnologies.com/rams/json_api');
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, true);
        curl_setopt($api_request, CURLOPT_POSTFIELDS, $data_pay_load);
        curl_setopt($api_request, CURLOPT_HTTPHEADER, array('Content-Type:
            application/json', 'Content-Length: ' . strlen($data_pay_load)));
        $result = curl_exec($api_request);
        $replace_syntax = str_replace('{"log":', "", $result);
        $replace_syntax1 = substr_replace($replace_syntax, "", -2);
        $moderateData = json_decode($replace_syntax1, true);


        return $moderateData;

    }

    public function fetchLog($s_date = null, $s_time = null, $e_date = null, $e_time = null)
    {

        $start_date = $s_date ?? date('Y-m-d', time());
        $start_time = $s_time ?? date('H:i:s', time());

        $end_date = $e_date ?? $s_date;
        $t = strtotime("+15 minutes", strtotime($start_time));
        $end_time = $e_time ?? date('H:i:s', $t);
        $access_id=27774600;


        // "operation":"fetch_log",
        // "auth_user":"John_Smith",
        // "auth_code":"xxxxxxxxxxxxxxxx",
        // "start_date":"2022-08-28",
        // "end_date":"2022-08-28",
        // "start_time":"10:49:09",
        // "end_time":"11:49:09",
        // "access_id":"27774600"

        // $data = array("operation" => "fetch_log", "auth_user"=>"theworld", "auth_code"
        // => "hy6s4fu3fodflkm7e9048mz1pjfku2w", "start_date" => $start_date, "end_date" =>
        //     $end_date, "start_time" => $start_time, "end_time" => $end_time);
     
            $data = array("operation" => "fetch_log", "auth_code"
        => "hy6s4fu3fodflkm7e9048mz1pjfku2w", "start_date" => $start_date, "end_date" =>
            $end_date, "start_time" => $start_time, "end_time" => $end_time, "access_id"=>$access_id);

        //  \Log::info($data);


        $data_pay_load = json_encode($data);
        $api_request = curl_init('https://rumytechnologies.com/rams/json_api');
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, true);
        curl_setopt($api_request, CURLOPT_POSTFIELDS, $data_pay_load);
        curl_setopt($api_request, CURLOPT_HTTPHEADER, array('Content-Type:
            application/json', 'Content-Length: ' . strlen($data_pay_load)));
        $result = curl_exec($api_request);
        $replace_syntax = str_replace('{"log":', "", $result);
     //   $replace_syntax1 = substr_replace($replace_syntax, "", -2);
        $replace_syntax1 = substr_replace($replace_syntax, "", -1);
        $moderateData = json_decode($replace_syntax1, true);

        return $moderateData;

    }

    public function fetchInovaceLog($s_date = null, $s_time = null, $e_date = null, $e_time = null)
    {

        $start_date = $s_date ?? date('Y-m-d', time());
        $start_time = $s_time ?? date('H:i:s', time());

        $end_date = $e_date ?? $s_date ?? $start_date;
        $t = strtotime("+15 minutes", strtotime($start_time));
        $end_time = $e_time ?? date('H:i:s', $t);
       
        // $api_tokens = [
        //     '1b1e-6b29-b88d-6d01-4b16-085f-943a-3875-fa33-ab0a-c43d-efa9-24a4-10ad-8cec-23ae',
        //     'a51f-4496-ede7-ccff-3f37-7198-2bfc-9436-60c8-e52b-8de7-2516-8b15-e6d4-ee17-7577',
        //     '87b1-e2c2-ed2c-d91d-3e0f-b4d0-e4a6-0d70-e51d-1f2b-dd71-52cc-57bc-d4cd-4bd3-c0c1',
        //     'b3d7-847e-018b-02c3-a1da-b755-95b5-1cf0-889e-ca65-e5b8-bc08-9f7a-77ff-ab13-ce36',
        //     'c2fb-5797-2ab0-16c2-977a-6f18-1ceb-4fc2-dd56-197e-67e4-62a8-9ba7-df0f-639d-645e',
        //     '0ac3-6fc4-5a44-ade5-c929-3051-3b36-68b8-dbb8-5ff8-5275-d3b8-db28-0766-27f6-e50e',
        //     'cdb3-8d3a-6a7b-4325-b9d4-27a2-5a69-4b67-eb93-49b3-7b3f-b559-238e-b6de-383c-b579',
        //     'dd59-0a84-90a5-1789-0d1b-83b1-f789-8475-9e1a-e76c-d6e6-750c-c5e4-acb0-7500-5968'
        // ];
        $api_tokens = [
          //  'cde1-c22b-5a22-78f2-c268-eb71-12ab-d067-c52b-0f30-700f-18f0-1a46-d9a2-8056-9ec4', //21896, 22003, 24490 gcom
            '0b94-de3a-923e-526f-9a39-37af-2500-074a-fc7b-6374-9bcd-7571-c224-7b37-296d-3a74', // 22291,22299
            'dd59-0a84-90a5-1789-0d1b-83b1-f789-8475-9e1a-e76c-d6e6-750c-c5e4-acb0-7500-5968', // 21895
            '0ac3-6fc4-5a44-ade5-c929-3051-3b36-68b8-dbb8-5ff8-5275-d3b8-db28-0766-27f6-e50e', // 22057, 22197
            '96d8-5cf7-814d-1add-c296-ed4e-dd4f-fecc-7bf8-043c-9794-96dd-70de-a240-70ad-6064', // 8805,8805 
            '1b1e-6b29-b88d-6d01-4b16-085f-943a-3875-fa33-ab0a-c43d-efa9-24a4-10ad-8cec-23ae', // 8644 
        ];

        $main_data = [];
        foreach ($api_tokens as $k => $api_token) {

            $url = 'http://api-inovace360.com/api/v1/logs/?api_token=' . $api_token . '&start=' .$start_date.'%20'.$start_time.'&end='.$end_date .'%20'.$end_time;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 300); 
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

            $result = curl_exec($ch);
            $jsn_decoded = json_decode($result);
            $main_data1 = $jsn_decoded->data;
            $main_data = array_merge($main_data, $main_data1);

            // only for date wise
        //     $api_request = curl_init('http://api-inovace360.com/api/v1/logs/?start=' . $start_date  . '&end=' . $end_date . '&api_token=' . $api_token . '&per_page=1000');
        //     curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        //     curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        //     curl_setopt($api_request, CURLOPT_POST, false);
        //     $result = curl_exec($api_request);

        //     $jsn_decoded = json_decode($result);
        //     $main_data1 = $jsn_decoded->data;
        //     $main_data = array_merge($main_data, $main_data1);

         
        }

        $issue = new    IssueDetail();
        $issue->issue_type = 'fetch:log';
        $issue->issuer_type = 'edu';
        $issue->issue_details = "Fetched(inovace): " . count($main_data) . ' logs. Start Date:' . $start_date . ' Start Time:' . $start_time . ' End Date:' . $end_date . ' End Time:' . $end_time;
        //$issue->issue_details = "Fetched(inovace): " . ($main_data ? count($main_data) : json_encode($result)) . json_encode($main_data);
        $issue->save();

       //  dd($main_data);
        return $main_data;

    }

    public function fetchLogByDevice($s_date = null, $s_time = null, $e_date = null, $e_time = null)
    {

    

        $start_date = $s_date ?? date('Y-m-d', time());
        $start_time = $s_time ?? date('H:i:s', time());

    //    dd($e_time);

        $end_date = $e_date ?? $s_date;
        $t = strtotime("+5 minutes", strtotime($start_time));
        $end_time = $e_time ?? date('H:i:s', $t);

        $mx_access_unique_id = 27774600;
      
        $data = array("operation" => "fetch_log",
          //  "auth_user"=> "chorjapod",
            "auth_code"=> "hy6s4fu3fodflkm7e9048mz1pjfku2w",
            "start_date" => $start_date, 
            "end_date" =>$end_date, 
            "start_time"=>$start_time, 
            "end_time" => $end_time, 
            "access_id"=>$mx_access_unique_id);
     

        $data_pay_load = json_encode($data);
        $api_request = curl_init('https://rumytechnologies.com/rams/json_api');
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, true);
        curl_setopt($api_request, CURLOPT_POSTFIELDS, $data_pay_load);
        curl_setopt($api_request, CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: ' . strlen($data_pay_load)));

        $result = curl_exec($api_request);
        $replace_syntax = str_replace('{"log":', "", $result);
        $replace_syntax1 = substr_replace($replace_syntax, "", -1);
        $moderateData = json_decode($replace_syntax1);

        $moderateData= is_array($moderateData) ? $moderateData : [];
        // issue store
        $issue = new IssueDetail();
        $issue->issue_type = 'fetch:log';
        $issue->issuer_type = 'edu';
        $issue->issue_details = "Fetched(stellar): " . count($moderateData) . ' logs. Start Date:' . $start_date . ' Start Time:' . $start_time . ' End Date:' . $end_date . ' End Time:' . $end_time;
        $issue->save();

       // dd($moderateData);
        
        return $moderateData;

     

    }

    public function fetchLogFromAccessId($days = 1, $access_unique_id = null)
    {

        $now = Carbon::now();

        $today_date = $now->toDateString();
        $previous_date = $now->subDays($days)->toDateString();

        $start_date = $previous_date;
        $start_time = '00:00:00';

        $end_date = $today_date;
        $end_time = '23:59:59';

        $log = new DeviceLog();
        $mx_access_unique_id = 27774600;
     //   $mx_access_unique_id = $access_unique_id;
    //   $end_time = $e_time ?? date('H:i:s', $t);
                    
            // "operation":"fetch_log",
            // "auth_user":"John_Smith",
            // "auth_code":"xxxxxxxxxxxxxxxx",
            // "start_date":"2022-08-28",
            // "end_date":"2022-08-28",
            // "start_time":"10:49:09",
            // "end_time":"11:49:09",
            // "access_id":"27774600"



        $data = array("operation" => "fetch_log", "auth_code"
        => "hy6s4fu3fodflkm7e9048mz1pjfku2w", "start_date" => $start_date, "end_date" =>
            $end_date, "start_time"=>$start_time, "end_time" => $end_time, "access_id"=>$mx_access_unique_id);
 
            // $data = array("operation" => "fetch_log","auth_user" => "theworld","auth_code"
            //     => "hy6s4fu3fodflkm7e9048mz1pjfku2w","start_date" => "2018-10-21","end_date" =>
            //     "2018-10-21","start_time" => "08:49:09",
            //     "end_time" => "15:49:09");
       

        $data_pay_load = json_encode($data);
        $api_request = curl_init('https://rumytechnologies.com/rams/json_api');
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, true);
        curl_setopt($api_request, CURLOPT_POSTFIELDS, $data_pay_load);
        curl_setopt($api_request, CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: ' . strlen($data_pay_load)));
       
        $result = curl_exec($api_request);
        $replace_syntax = str_replace('{"log":', "", $result);
        $replace_syntax1 = substr_replace($replace_syntax, "", -1);
        $moderateData = json_decode($replace_syntax1);

        $moderateData= is_array($moderateData) ? $moderateData : [];
        // dd($result);

        return $moderateData;
        
    }


    public function saveDeviceLogToEduDb($data, $company)
    {

      
        if (count($data) <= 0 && $company == null) {
            return false;
        }

        $saved = 0;

        if ($company == 'stellar') {
           
            foreach ($data as $i => $v) {
              //  dd($v->registration_id);
                // $biometricNumber = $v['registration_id'];
                // $access_time = $v['access_time'];
                // $access_id = $v['access_id'];
                // $attendance_date = $v['access_date'];
                // $unit_id = $v['unit_id'];

                $biometricNumber = $v->registration_id;
                $access_time = $v->access_time;
                $access_id = $v->access_id;
                $attendance_date = $v->access_date;
                $unit_id = $v->unit_id;
                $log = new DeviceLog();
                $exist = $log->where('log_id', $access_id)->first();

                if (!$exist) {
                      $log = new DeviceLog();
                    $log->log_id = $access_id;
                    $log->company = 'stellar';
                    $log->device_id = $unit_id;
                    $log->user_biometric_id = $biometricNumber;
                    $log->access_time = $access_time;
                    $log->access_date = $attendance_date;
                    $log->access_date_time = $attendance_date . ' ' . $access_time;
                    $log->save();
                    $saved++;
                }
            }
        }
        if ($company == 'inovace') {

            foreach ($data as $i => $v) {

                $biometricNumber = $v->person_identifier;
                $access_time = date('H:i:s', strtotime($v->logged_time));
                $access_id = $v->uid;
                $attendance_date = date('Y-m-d', strtotime($v->logged_time));
                $unit_id = $v->device_identifier;

                $log = new DeviceLog();
                $exist = $log->where('log_id', $access_id)->first();

                if (!$exist) {
                    $log->log_id = $access_id;
                    $log->company = 'inovace';
                    $log->device_id = $unit_id;
                    $log->user_biometric_id = $biometricNumber;
                    $log->access_time = $access_time;
                    $log->access_date = $attendance_date;
                    $log->access_date_time = $v->logged_time;
                    $log->save();
                    $saved++;
                }
            }
        }
        return $saved;
    }


}
