<?php

namespace App\Traits;

trait LiveStreamingApiTrait
{

    function generate_signature($api_key, $api_secret, $meeting_number, $role)
    {

        $time = time() * 1000 - 30000;//time in milliseconds (or close enough)

        $data = base64_encode($api_key . $meeting_number . $time . $role);

        $hash = hash_hmac('sha256', $data, $api_secret, true);

        $_sig = $api_key . "." . $meeting_number . "." . $time . "." . $role . "." . base64_encode($hash);

        //return signature, url safe base64 encoded
        return rtrim(strtr(base64_encode($_sig), '+/', '-_'), '=');
    }


    public function zoomMeetingCreate($data = array())
    {
        $start_time = $data['start_time'];
        $createAMeetingArray = array();
        if (!empty($data['alternative_host_ids'])) {
            if (count($data['alternative_host_ids']) > 1) {
                $alternative_host_ids = implode(",", $data['alternative_host_ids']);
            } else {
                $alternative_host_ids = $data['alternative_host_ids'][0];
            }
        }
        $createAMeetingArray['topic'] = $data['topic'];
        $createAMeetingArray['agenda'] = !empty($data['agenda']) ? $data['agenda'] : "";
        $createAMeetingArray['type'] = !empty($data['type']) ? $data['type'] : 2; //Scheduled
        $createAMeetingArray['start_time'] = $start_time;
        $createAMeetingArray['timezone'] = 'PST';
        $createAMeetingArray['password'] = !empty($data['password']) ? $data['password'] : "";
        $createAMeetingArray['duration'] = !empty($data['duration']) ? $data['duration'] : 60;
        $createAMeetingArray['settings'] = array(
            'join_before_host' => !empty($data['join_before_host']) ? true : false,
            'host_video' => !empty($data['option_host_video']) ? true : false,
            'participant_video' => !empty($data['option_participants_video']) ? true : false,
            'mute_upon_entry' => !empty($data['option_mute_participants']) ? true : false,
            'enforce_login' => !empty($data['option_enforce_login']) ? true : false,
            'auto_recording' => !empty($data['option_auto_recording']) ? $data['option_auto_recording'] : "none",
            'alternative_hosts' => isset($alternative_host_ids) ? $alternative_host_ids : ""
        );

        $request_url = "https://api.zoom.us/v2/users/" . $data['email'] . "/meetings";
//type :8 for recurrence meeting
        // $createAMeetingArray["start_time"]
        $postFields2 = '{
          "topic":"' . $createAMeetingArray["topic"] . '",
          "type": 7,
          "start_time": "' . $createAMeetingArray["start_time"] . '",
          "duration": 40,
          "timezone": "Asia/Dhaka",
          "password": "lllll",
          "agenda": "Live Class",
          "tracking_fields": [
            {
              "field": "string",
              "value": "string"
            }
          ],
          "recurrence": {
            "type":1,
            "repeat_interval": 1,
            "weekly_days": "",
            "monthly_day": "",
            "monthly_week": "",
            "monthly_week_day": "",
            "end_times": "",
            "end_date_time": "2020-10-25T12:00:00Z"
              },
          "settings": {
            "host_video": true,
            "participant_video": true,
            "cn_meeting": false,
            "in_meeting": false,
            "join_before_host": false,
            "mute_upon_entry": true,
            "watermark": false,
            "use_pmi": false,
            "approval_type": 0,
            "registration_type": 1,
            "audio":"voip",
            "enforce_login": false,
            "enforce_login_domains": "",
            "alternative_hosts": "",
            "registrants_email_notification": false
          }
        }';

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $request_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $postFields2,
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer " . $data['token'],
                "content-type: application/json",
                "Accept: application/json",
            ),
        ));


        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if (!$response) {
            return $err;
        }


        return $response;


        /*

                +"uuid": "OFunlN+HRbqg0/41pbgXMw=="
            +"id": 76829650800
            +"host_id": "YcQLgGReTcq444QaxxDwpw"
            +"host_email": "fawel99@gmail.com"
            +"topic": "Example Test Meeting1"
            +"type": 2
            +"status": "waiting"
            +"start_time": "2020-10-09T06:09:06Z"
            +"duration": 45
            +"timezone": "Asia/Dhaka"
            +"agenda": "Zoom WordPress"
            +"created_at": "2020-10-09T06:09:06Z"
            +"start_url": "https://us04web.zoom.us/s/76829650800?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJZY1FMZ0dSZVRjcTQ0NFFheHhEd ▶"
            +"join_url": "https://us04web.zoom.us/j/76829650800?pwd=dlBWOTdGKzZFWkJER0xLbUxqem1aZz09"
            +"password": "1234"
            +"h323_password": "1234"
            +"pstn_password": "1234"
            +"encrypted_password": "dlBWOTdGKzZFWkJER0xLbUxqem1aZz09"
            +"settings": {#3286 ▼
                +"host_video": true
                +"participant_video": true
                +"cn_meeting": false
                +"in_meeting": false
                +"join_before_host": false
                +"mute_upon_entry": true
                +"watermark": false
                +"use_pmi": false
                +"approval_type": 2
                +"audio": "voip"
                +"auto_recording": "none"
                +"enforce_login": false
                +"enforce_login_domains": ""
                +"alternative_hosts": ""
                +"close_registration": false
                +"registrants_confirmation_email": true
                +"waiting_room": true
                +"request_permission_to_unmute_participants": false
                +"contact_name": "Nur Uddin"
                +"contact_email": "fawel99@gmail.com"
                +"registrants_email_notification": false
                +"meeting_authentication": false
          }
        }*/


    }

    public function getMeeting($id, $token)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.zoom.us/v2/meetings/" . $id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer " . $token,
                "content-type: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        //  dd($response);

        if ($err) {
            return $err;
        } else {
            return $response;
        }

    }
    public function getMeetingParticipants($id, $token)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.zoom.us/v2/past_meetings/".$id."/participants/" ,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer " . $token,
                "content-type: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

          dd($response);

        if ($err) {
            return $err;
        } else {
            return $response;
        }

    }


    public function deleteZoomMeeting($m_id, $token)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.zoom.us/v2/meetings/" . $m_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer " . $token,
                "content-type: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        // dd($response);

        if ($err) {
            return $err;
        } else {
            return $response;
        }

    }


    public function getAllZoomMeetings($token, $email)
    {


        $curl = curl_init();


        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.zoom.us/v2/users/" . $email . "/meetings",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer " . $token,
                "content-type: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            // echo "cURL Error #:" . $err;
            return $err;
        } else {
            return $response;
        }

    }


    public function addParticipant($id,$token)
    {
        $request_url = "https://api.zoom.us/v2/meetings/".$id."/registrants";


        $postFields2 = '{"email": "fawel90@gmail.com",
  "first_name": "Mike",
  "last_name": "Brown",
  "address": "123 Main ST",
  "city": "San Jose",
  "country": "US",
  "zip": "95550",
  "state": "CA",
  "phone": "111-444-4444",
  "industry": "Tech",
  "org": "IT",
  "job_title": "DA",
  "purchasing_time_frame": "More Than 6 Months",
  "role_in_purchase_process": "Influencer",
  "no_of_employees": "1-20",
  "comments": "Excited to host you.",
  "custom_questions": [
    {
      "title": "Favorite thing about Zoom",
      "value": "Meet Happy"
    }
  ]
        }';


        //  dd($postFields2, json_encode($postFields, true));
        //   $postFields1 = json_encode($postFields, false);

        $ch = curl_init();


        curl_setopt_array($ch, array(
            CURLOPT_URL => $request_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $postFields2,
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer ".$token,
                "content-type: application/json",
                "Accept: application/json",
            ),
        ));


        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if (!$response) {
            return $err;
        }

        dd($response);
        return json_decode($response);
    }

    public function ff()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.zoom.us/v2/users?status=active&page_size=30&page_number=1",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhdWQiOm51bGwsImlzcyI6IndxLThvQXdEU19LREZrRkpRblNuV0EiLCJleHAiOjE2MDE4MjkyNjcsImlhdCI6MTYwMTgyMzg2OH0.UOlJnIb_PtgG94fQfV-6CcFZ25mUXcAkavdMV8oXeP4",
                "content-type: application/json"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            dd($response);
        }
    }
}



