<?php

namespace App\Traits\Device;

use App\Jobs\SendAttSmsJob;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Edu\Device\DeviceLog;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Models\Site\Employee\GlobalEmployeeShift;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteMembership;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Traits\SmsFunctionsTrait;
use App\Traits\TimeRelatedFunctionTrait;

use Carbon\Carbon;
use DateInterval;
use DateTime;
use DB;
use Exception;
use Log;
use Mail;

trait OrganizeSavedDeviceLogTrait
{
    use SmsFunctionsTrait, TimeRelatedFunctionTrait;


    public function organizeSavedDeviceLog($saved_device_log)
    {
      //  dd('sfsfsf');
       
        // return $saved_device_log;

        /*  $start_date = $s_date;
          $start_time = $s_time;
          $end_date = $e_date;
          $end_time = $e_time;


          $get_device_log = (new DeviceLog())
              ->whereBetween('access_date', [$start_date, $end_date])
              ->whereBetween('access_time', [$start_time, $end_time])
              ->get();*/

            //   student
            // id: 71853,
            // log_id: "aa97681d8cbd4378f8291354acfa6962",
            // device_id: "8644",
            // company: "inovace",
            // user_biometric_id: "2115000198",
            // access_time: "09:15:39",
            // access_date: "2021-12-27",
            // access_date_time: "2021-12-27 09:15:39",
            // executed_status: 1,
            // executed_time: "2021-12-27 17:04:12",
            // executed_message: "End Of Line: Startedprevious:",
            // status: 1,
            // created_at: "2021-12-27 17:02:54",
            // updated_at: "2021-12-27 17:04:12"

            // employee
            // id: 71791,
            // log_id: "521e48bb4225808c4c4462aff2396387",
            // device_id: "8644",
            // company: "inovace",
            // user_biometric_id: "e211500006",
            // access_time: "09:36:02",
            // access_date: "2021-12-24",
            // access_date_time: "2021-12-24 09:36:02",
            // executed_status: 1,
            // executed_time: "2021-12-27 17:04:12",
            // executed_message: "End Of Line: Startedprevious:",
            // status: 1,
            // created_at: "2021-12-27 17:02:53",
            // updated_at: "2021-12-27 17:04:12"


        $device_logs = $saved_device_log;

        $data_saved = [];
        $data_updated = [];
        $emp_saved = [];
        $emp_updated = [];
     
        if (count($device_logs) < 1) {
            return [$data_saved, $data_updated, $emp_saved, $emp_updated];
        }

        $now = Carbon::now();
        $today = $now->toDateString();
      
      
        foreach ($device_logs as $i => $v) {

            $biometricNumber = $v->user_biometric_id;
            $access_time = $v->access_time;
            $access_id = $v->id;
            $attendance_date = $v->access_date;
            $unit_id = $v->device_id;

           
            $get_user = GlobalUser::where('username', $biometricNumber)
                ->where('status', 1)
                ->select(['id', 'alias', 'user_type', 'academic_group_id', 'site_id', 'phone', 'contact_number', 'username', 'attendance_sms'])
                ->first();//academic_group_id site_id user_type id
          
                 //send out  sms
        
 
            $message = 'Started';

            $the_device_log = (new DeviceLog())
                ->where('id', $v->id)
                ->first();
            

            if ($get_user) {

                $site_id = $get_user->site_id;
                $academic_group_id = $get_user->academic_group_id;
                $student_id = $get_user->id;
                $user_type = $get_user->user_type;
                $attendance_sms = $get_user->attendance_sms;
                $day = date('D', strtotime($attendance_date));//sun

                $site = GlobalSiteInfo::where('id',$site_id)->first();
           
                $site_setting = GlobalSiteInfoSetting::
                    where('site_id', $site_id)
                    ->when($academic_group_id, function ($q) use ($academic_group_id) {
                        $q->where('academic_group_id', $academic_group_id);
                    })
                    ->select('id','st_in_sms', 'st_out_sms', 'sms_lang','emp_in_sms', 'emp_out_sms','academic_group_id','site_id','regards_title')
                    ->first();
             //   dd($site_setting);
                    if (!$site_setting) {
    
                        $issue = new    IssueDetail();
                        $issue->username = $biometricNumber;
                        $issue->issuer_type = 'edu';
                        $issue->issue_type = 'organize:log';
                        $issue->issue_details = 'site_id:' . $site_id . ' academic_group_id:' . $academic_group_id . ' Site Info Settings Not Found';
                        $issue->access_time = $access_time;
                        $issue->attendance_date = $attendance_date;
                        $issue->device_id = $unit_id;
                        $issue->access_id = $access_id;
                        $issue->save();
                        continue;
    
                    }
    
                $sms_lang = $site_setting->sms_lang;//en bn
                $sms_text_lang = $sms_lang == 'en' ? 'text' : 'unicode';

                $regards_title=$site_setting->regards_title?$site_setting->regards_title:$site->short_name;

                $the_device_log->executed_status = 1;
                $the_device_log->executed_time = $now->toDateTimeString();
                $the_device_log->executed_message = 'user_type: ' . $user_type . ' message:' . $message;
                $the_device_log->save();

                if ($user_type == 'student') {

                    $academic_group_id = $get_user->academic_group_id;

                    $get_period_type_duration = DB::table('site_period_type_durations')
                        ->where('start_date', '<=', $attendance_date)
                        ->where('end_date', '>=', $attendance_date)
                        ->where('academic_group_id', $academic_group_id)
                        ->where('site_id', $site_id)
                        ->first();
                      
                    if (!$site_id || !$academic_group_id || !$get_period_type_duration) {

                        $issue = new IssueDetail();
                        $issue->username = $biometricNumber;
                        $issue->issuer_type = 'edu';
                        $issue->issue_type = 'organize:log';
                        $issue->issue_details = 'site_id:' . $site_id . ' academic_group_id:' . $academic_group_id . ' period_type_duration:' . $get_period_type_duration;
                        $issue->access_time = $access_time;
                        $issue->attendance_date = $attendance_date;
                        $issue->device_id = $unit_id;
                        $issue->access_id = $access_id;
                        $issue->save();
                        continue;

                    }

                    $student_history = GlobalStudentHistory::
                    where('user_id', $student_id)
                        ->select(['id', 'user_id', 'academic_class_id', 'academic_department_id', 'registration_no', 'academic_session_id', 'academic_group_id',
                            'academic_section_id', 'academic_year_id', 'academic_version_id', 'academic_shift_id', 'academic_class_group_id',
                        ])
                        ->where('status', 1)
                        ->get();
                      //  dd($student_history);
                    if (count($student_history) > 0) {
                        foreach ($student_history as $ky => $item) {

                            $stdAttendance = new GlobalStudentAttendance();

                            $st_shift_id = $item->academic_shift_id;
                            $acc_group_id = $item->academic_group_id;
                            $st_history_id = $item->id;

                            $st_shift_details = DB::table('site_shift_details')
                                ->where('academic_shift_id', $st_shift_id)//day
                                ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)//regular
                                ->where('belongs_to', 'student')
                                ->where('week_day', $day)//sunday
                                ->where('academic_group_id', $acc_group_id)
                                ->where('status', true)
                                ->where('site_id', $site_id)
                                ->first();
                          

                            if (!$st_shift_details) {

                                $subject = 'Student Shift Details Not found in organizeSavedDeviceLog() 124';

                                $data = [
                                    'name' => $get_user->first_name . ' ' . $get_user->first_name,
                                    'username' => $get_user->username,
                                    'sub_domain' => 'n/a',
                                    'password' => 'n/a',
                                    'message' => 'No shift details found for the student ',
                                    'user_id' => 'n/a'
                                ];
                                $issue = new  IssueDetail();
                                $issue->username = $biometricNumber;
                                $issue->issuer_type = 'site';
                                $issue->issue_type = 'attendance';
                                $issue->issue_details = $subject;
                                $issue->access_time = $access_time;
                                $issue->attendance_date = $attendance_date;
                                $issue->device_id = $unit_id;
                                $issue->access_id = $access_id;
                                $issue->site_id = $site_id;
                                $issue->save();

                                continue;
                            }


                            $existed_st_attendance = $stdAttendance
                                ->where('present_date', $attendance_date)
                                ->where('student_history_id', $st_history_id)
                                ->where('site_shift_details_id', $st_shift_details->id)
                                ->where('site_id', $site_id)
                                ->where(function ($query) {
                                    $query->where('present_type', 'device')
                                        ->orWhere('present_type', 'web');
                                })
                                ->first();
                              //  dd($existed_st_attendance);

                            // return  $existed_st_attendance;


                            if ($existed_st_attendance) {// st att found out time

                                // Log::info($get_user->first_name.' username : '.$biometricNumber);
                           
                                if ($existed_st_attendance->in_time && $existed_st_attendance->out_time) {

                                    $issue = new    IssueDetail();
                                    $issue->username = $biometricNumber;
                                    $issue->issuer_type = 'site';
                                    $issue->issue_type = 'attendance';
                                    $issue->issue_details = $existed_st_attendance->id . "-Student In and Out done. In:" . $existed_st_attendance->in_time . ' Out:' . $existed_st_attendance->out_time;
                                    $issue->access_time = $access_time;
                                    $issue->attendance_date = $attendance_date;
                                    $issue->device_id = $unit_id;
                                    $issue->access_id = $access_id;
                                    $issue->site_id = $site_id;
                                    $issue->save();

                                    continue;
                                }

                                if ($existed_st_attendance->in_time && !$existed_st_attendance->out_time && ($existed_st_attendance->in_time != $access_time)) {//out time not taken previously


                                    $existed_in_time = strtotime($existed_st_attendance->in_time);//10:01:00 AM
                                    $given_access_time = strtotime($access_time);// 11:50:00 AM
                                    $difference = (($given_access_time - $existed_in_time) / 60);

                                    if ($difference >= 10) {//10 min diff btw in and out

                                        $existed_st_attendance->student_history_id = $st_history_id;
                                        $existed_st_attendance->present_type = 'device';
                                        $existed_st_attendance->site_shift_details_id = $st_shift_details->id;
                                        $existed_st_attendance->out_access_id = $access_id;
                                        $existed_st_attendance->out_device_id = $unit_id;
                                        $existed_st_attendance->out_time = $access_time;
                                        $existed_st_attendance->present_date = $attendance_date;
                                        $existed_st_attendance->present_date_time = $attendance_date . ' ' . $access_time;
                                        $existed_st_attendance->present_year = date('Y', strtotime($attendance_date));
                                        $existed_st_attendance->present_month = date('m', strtotime($attendance_date));
                                        $existed_st_attendance->present_day = date('d', strtotime($attendance_date));
                                        $existed_st_attendance->save();

                                        $data_updated[$st_history_id] = $existed_st_attendance->id;

                                       

                                        if ($site_setting && $site_setting->st_out_sms && ($attendance_date == $today)) {// out sms option and today


                                            //check user sms off or on
                                            if (!$attendance_sms) {
                                                $issue = new    IssueDetail();
                                                $issue->username = $biometricNumber;
                                                $issue->issuer_type = 'site';
                                                $issue->issue_type = 'sms';
                                                $issue->issue_details = "Student SMS Off individually-Out";
                                                $issue->access_time = $access_time;
                                                $issue->attendance_date = $attendance_date;
                                                $issue->device_id = $unit_id;
                                                $issue->access_id = $access_id;
                                                $issue->site_id = $site_id;
                                                $issue->save();
                                                continue;
                                            }



                                            $st_name = $get_user->first_name . ' ' . $get_user->last_name;
                                           
                                            $site_name = 'Regards: ' . $regards_title;
                                           
                                            $in_time = 'Out Time: ' . date('g:i A', strtotime($access_time));
                                            $att_date = 'Attendance Date: ' . date('d M Y', strtotime($attendance_date));

                                            $with_in_time = '';

                                            if ($sms_lang && $sms_lang == 'bn') {
                                                $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                                                $site_name = 'প্রতিষ্ঠান:' . ($site->translate($sms_lang)->short_name ?? 'N/A');
                                                
                                                $in_time = 'বাহির: ' . date('g:i A', strtotime($access_time));
                                                
                                                $a_date = $this->getDateInDifferentLanguage( date('d M Y', strtotime($attendance_date)), $sms_lang);
                                                $att_date = 'তারিখ: ' .$a_date;
                                                    
                                                $with_in_time = 'আগমন: ' . date('g:i A', strtotime($existed_st_attendance->in_time));


                                                //$in_time=$in_time;
                                            } elseif ($sms_lang && $sms_lang == 'en') {
                                                $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                                                $site_name = 'Regards: ' . $regards_title;
                                                $with_in_time = 'In Time: ' . date('g:i A', strtotime($existed_st_attendance->in_time));
                                            }
                                            
                                                
                                            $sms_txt = $st_name;
                                            $sms_txt .= ', ' . $in_time;
                                            $sms_txt .= ', ' . $att_date;
                                            $sms_txt .= ', ' . $site_name;

                                            if (!$site_setting->st_in_sms) {
                                                $sms_txt .= ', ' . $with_in_time;
                                            }


                                            $att_data_for_queue = [];
                                            $att_data_for_queue['att_user_type'] = 'student';
                                            $att_data_for_queue['att_type'] = 'out';//in or out
                                            $att_data_for_queue['att_table_id'] = $existed_st_attendance->id;

                                            $existed_st_attendance->out_sms_id = 1;
                                            $existed_st_attendance->save();


                                            if (!$this->sendAttendanceSms1([$get_user->contact_number], $sms_txt, $site_id, $att_data_for_queue)) {

                                                $issue = new    IssueDetail();
                                                $issue->username = $biometricNumber;
                                                $issue->issuer_type = 'site';
                                                $issue->issue_type = 'attendance';
                                                $issue->issue_details = 'sendAttendanceSms returns false';
                                                $issue->access_time = $access_time;
                                                $issue->attendance_date = $attendance_date;
                                                $issue->device_id = $unit_id;
                                                $issue->access_id = $access_id;
                                                $issue->site_id = $site_id;
                                                $issue->save();
                                                continue;
                                            }
                                            //sms
                                            $message = 'Sms Sent to queue';


                                        } else {// out sms option and today  else

                                            $issue = new    IssueDetail();
                                            $issue->username = $biometricNumber;
                                            $issue->issuer_type = 'site';
                                            $issue->issue_type = 'attendance';
                                            $issue->issue_details = "Site Setting(" . $site_setting . ") Or Site out SMS: " . $site_setting->st_out_sms . ") Attendance date:" . $attendance_date . " Today:" . $today;
                                            $issue->access_time = $access_time;
                                            $issue->attendance_date = $attendance_date;
                                            $issue->device_id = $unit_id;
                                            $issue->access_id = $access_id;
                                            $issue->site_id = $site_id;
                                            $issue->save();
                                            continue;
                                        }
                                    } else {//>=10 min diff btw in and out -else

                                        //out not taken as it is less than 10 mins

                                        $issue = new    IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->issuer_type = 'site';
                                        $issue->issue_type = 'attendance';
                                        $issue->issue_details = "Difference: " . $difference . " Access Time " . $access_time . ' Existed In Time:' . $existed_st_attendance->in_time . ' must be 10 min or more';
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;
                                    }

                                } else {// else of --$existed_st_attendance->in_time && !$existed_st_attendance->out_time && ($existed_st_attendance->in_time != $access_time)

                                    $issue = new    IssueDetail();
                                    $issue->username = $biometricNumber;
                                    $issue->issuer_type = 'site';
                                    $issue->issue_type = 'attendance';
                                    $issue->issue_details = "In time:" . $existed_st_attendance->in_time . "  Out time Not found And existed in time & this time same)";
                                    $issue->access_time = $access_time;
                                    $issue->attendance_date = $attendance_date;
                                    $issue->device_id = $unit_id;
                                    $issue->access_id = $access_id;
                                    $issue->site_id = $site_id;
                                    $issue->save();
                                    continue;
                                }

                            } else {//previous att not found In time


                                //check if off day and att_allowed
                                $off_day_att = false;
                                if (!$st_shift_details->day_on && !$st_shift_details->att_allowed) {

                                    $issue = new    IssueDetail();
                                    $issue->username = $biometricNumber;
                                    $issue->issuer_type = 'site';
                                    $issue->issue_type = 'attendance';
                                    $issue->issue_details = 'OFF Day  && Attendance Not Allowed on:' . $attendance_date;
                                    $issue->access_time = $access_time;
                                    $issue->attendance_date = $attendance_date;
                                    $issue->device_id = $unit_id;
                                    $issue->access_id = $access_id;
                                    $issue->site_id = $site_id;
                                    $issue->save();
                                    continue;
                                }
                                if (!$st_shift_details->day_on && $st_shift_details->att_allowed) {
                                    $off_day_att = true;
                                }

                                if ($this->isAttendanceInvalid($access_time, $st_shift_details)) {// check if time is invalid

                                    $att_time_should_be_min = $this->minusMinutesToTime($st_shift_details->in_time, $st_shift_details->in_time_allowed_min);

                                    $data = $get_user->first_name . ' ' . $get_user->last_name;
                                    $data .= ' Sorry ';
                                    $data .= ' In time ' . date('g:i A', strtotime($access_time));
                                    $data .= ' Minimum: ' . date('g:i A', strtotime($att_time_should_be_min));
                                    $data .= ' Attendance Date: ' . date('d-m-Y', strtotime($attendance_date));


                                    $issue = new    IssueDetail();
                                    $issue->username = $biometricNumber;
                                    $issue->issuer_type = 'site';
                                    $issue->issue_type = 'attendance';
                                    $issue->issue_details = $data;
                                    $issue->access_time = $access_time;
                                    $issue->attendance_date = $attendance_date;
                                    $issue->device_id = $unit_id;
                                    $issue->access_id = $access_id;
                                    $issue->site_id = $site_id;
                                    $issue->save();
                                    continue;
                                }


                                $get_late_status = $this->checkIsLate($get_user, $access_time, $st_shift_details);

                                $stdAttendance->student_history_id = $st_history_id;
                                $stdAttendance->present_type = 'device';
                                $stdAttendance->site_shift_details_id = $st_shift_details->id;
                                $stdAttendance->in_time = $access_time;
                                $stdAttendance->in_access_id = $access_id;
                                $stdAttendance->in_device_id = $unit_id;
                                $stdAttendance->present_date = $attendance_date;
                                $stdAttendance->present_date_time = $attendance_date . ' ' . $access_time;
                                $stdAttendance->present_year = date('Y', strtotime($attendance_date));
                                $stdAttendance->present_month = date('m', strtotime($attendance_date));
                                $stdAttendance->present_day = date('d', strtotime($attendance_date));
                                $stdAttendance->late_status = $get_late_status;
                                $stdAttendance->off_day_att = $off_day_att;
                                $stdAttendance->site_id = $site_id;
                                $stdAttendance->academic_group_id = $academic_group_id;
                                $stdAttendance->save();
                                $data_saved[$st_history_id] = $stdAttendance->id;

                                // $site = GlobalSiteInfo::whereId($site_id)->first();

                                // $site_setting = SiteInfoSetting::where('academic_group_id', $get_user->academic_group_id)
                                //     ->where('site_id', $get_user->site_id)
                                //     ->select('st_in_sms', 'sms_lang')
                                //     ->first();

                                if (!$site_setting) {
                                    $issue = new IssueDetail();
                                    $issue->username = $biometricNumber;
                                    $issue->access_time = $access_time;
                                    $issue->device_id = $unit_id;
                                    $issue->issuer_type = 'site';
                                    $issue->issue_type = 'attendance';
                                    $issue->issue_details = 'site Setting: ' . $site_setting . "acc group:" . $get_user->academic_group_id . ' site_id: ' . $get_user->site_id;
                                    $issue->site_id = $site_id;
                                    $issue->save();
                                    continue;
                                }

                                $st_in_sms_sett = $site_setting->st_in_sms;
                                $sms_lang = $site_setting->sms_lang;//en bn


                                if ($site_setting && $st_in_sms_sett && ($attendance_date == $today)) {// in sms
                                    $sms_balance = $site->siteMembership->sms_balance ?? 0;

                                    if ($sms_balance <= 0) {

                                        $issue = new    IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->access_time = $access_time;
                                        $issue->device_id = $unit_id;
                                        $issue->issuer_type = 'site';
                                        $issue->issue_type = 'sms';
                                        $issue->issue_details = 'Remaining Balance: ' . $sms_balance . ' Institute: ' . $site->short_name;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;

                                    }
                                    //check user sms off or on
                                    if (!$attendance_sms) {
                                        $issue = new    IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->issuer_type = 'site';
                                        $issue->issue_type = 'sms';
                                        $issue->issue_details = "Student SMS Off Individually-In";
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;
                                    }

                                    //    $response= $site_name->translate($lang)->short_name ?? $site_name->short_name;
                                    $st_name = $get_user->first_name . ' ' . $get_user->last_name;
                                  
                                    $site_name = 'Regards: ' . $regards_title;

                                    $in_time = 'In Time: ' . date('g:i A', strtotime($access_time));
                                    $att_date = 'Attendance Date: ' . date('d M Y', strtotime($attendance_date));
                                    
                              
                                
                                    // if ($sms_lang && $sms_lang == 'bn') {
                                    //     $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                                    //    //  $st_name = $get_user->first_name . ' ' . $get_user->last_name;  // this line use for some time
                                    //     $site_name = 'প্রতিষ্ঠান:' . ($site->translate($sms_lang)->short_name ?? 'N/A');
                                    //     $in_time = ' আগমন: ' . date('g:i A', strtotime($access_time));
                                        
                                    //     $a_date = $this->getDateInDifferentLanguage( date('d M Y', strtotime($attendance_date)), $sms_lang);
                                    //     $att_date = 'তারিখ: ' .$a_date;
                                                         
                                    //   //  $att_date = 'তারিখ: ' . date('d M Y', strtotime($attendance_date));


                                    //     //$in_time=$in_time;
                                    // } elseif ($sms_lang && $sms_lang == 'en') {
                                    //     $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                                    //     $site_name = 'Regards: ' . ($site->translate($sms_lang)->short_name ?? 'N/A');

                                    // }
                              
                                    $sms_txt = $st_name;
                                    $sms_txt .= ', ' . $in_time;
                                    $sms_txt .= ', ' . $att_date;
                                    $sms_txt .= ', ' . $site_name;

                                    $att_data_for_queue = [];
                                    $att_data_for_queue['att_user_type'] = 'student';
                                    $att_data_for_queue['att_type'] = 'in';//in or out
                                    $att_data_for_queue['att_table_id'] = $stdAttendance->id;

                                    $sms_text_lang = $sms_lang == 'en' ? 'text' : 'unicode';

                                    if (!$this->sendAttendanceSms1([$get_user->contact_number], $sms_txt, $site_id, $att_data_for_queue)) {

                                        $issue = new    IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->issuer_type = 'site';
                                        $issue->issue_type = 'attendance';
                                        $issue->issue_details = 'sendAttendanceSms returns false';
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;
                                    }
                                    
                                    $stdAttendance->in_sms_id = 1;
                                    $stdAttendance->save();

                                    // dispatch(new SendAttSmsJob([$get_user->contact_number], $data, $att_data_for_queue));
                                } else {
                                    $issue = new    IssueDetail();
                                    $issue->username = $biometricNumber;
                                    $issue->access_time = $access_time;
                                    $issue->device_id = $unit_id;
                                    $issue->issuer_type = 'site';
                                    $issue->issue_type = 'sms';
                                    $issue->issue_details = "Site Setting(" . $site_setting . ")  Site in SMS: " . $st_in_sms_sett . ") Attendance date:" . $attendance_date . " Today:" . $today;
                                    $issue->site_id = $site_id;
                                    $issue->save();
                                    continue;
                                }
                                //dd('in no sent');
                            }

                            continue;// continue to next log loop skipping second student history
                        }
                    }

                } elseif ($user_type == 'employee') {

                 

                    $emp_attendance = new GlobalEmployeeAttendance();

                    $emp_shifts = GlobalEmployeeShift::
                        where('user_id', $get_user->id)
                        ->whereNull('release_date')
                        ->orderBy('id', 'DESC')
                        ->get();
                      
                    if (count($emp_shifts) > 0) {
               // dd($emp_shifts);
                        $get_period_type_duration = DB::table('site_period_type_durations')
                            ->where('start_date', '<=', $attendance_date)
                            ->where('end_date', '>=', $attendance_date)
                            ->where('academic_group_id', $emp_shifts[0]->academic_group_id)
                            ->where('site_id', $site_id)
                            ->first();

                        // dd($get_period_type_duration);

                        if (!$get_period_type_duration) {
                            $issue = new IssueDetail();
                            $issue->username = $biometricNumber;
                            $issue->issue_type = 'attendance';
                            $issue->issuer_type = 'site';
                            $issue->issue_details = "Employee Period Type Duration Not Found. Date:" . $attendance_date . " Acc Group: " . $emp_shifts[0]->academic_group_id . " Site:" . $site_id;
                            $issue->access_time = $access_time;
                            $issue->attendance_date = $attendance_date;
                            $issue->device_id = $unit_id;
                            $issue->access_id = $access_id;
                            $issue->site_id = $site_id;
                            $issue->save();
                            continue;
                        }
                      

                        if (count($emp_shifts) > 5) {// more than 5 shift

                            $issue = new IssueDetail();
                            $issue->username = $biometricNumber;
                            $issue->issue_type = 'attendance';
                            $issue->issuer_type = 'site';
                            $issue->issue_details = "Not saved. >5 shift found ";
                            $issue->access_time = $access_time;
                            $issue->attendance_date = $attendance_date;
                            $issue->device_id = $unit_id;
                            $issue->access_id = $access_id;
                            $issue->site_id = $site_id;
                            $issue->save();
                            continue;

                        } else {// max 1 shift


                            $emp_shift_details = DB::table('site_shift_details')
                                ->where('academic_shift_id', $emp_shifts[0]->academic_shift_id)//day
                                ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)//regular
                                ->where('belongs_to', 'employee')
                                ->where('week_day', $day)//sunday
                              //  ->where('day_on', true)
                                ->where('status', true)
                                ->where('site_id', $site_id)
                                ->first();
                           //   dd($emp_shift_details);
                              
                            if ($emp_shift_details) {

                                $existed_emp_attendance = $emp_attendance
                                    ->where('user_id', $get_user->id)
                                    ->where('present_date', $attendance_date)
                                    ->where('site_shift_details_id', $emp_shift_details->id)
                                    ->first();

                                if ($existed_emp_attendance) {

                                    if ($existed_emp_attendance->in_time && $existed_emp_attendance->out_time) {

                                        $issue = new   IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->issue_type = 'attendance';
                                        $issue->issuer_type = 'site';
                                        $issue->issue_details = "In & Out Done. In:" . $existed_emp_attendance->in_time . ' Out:' . $existed_emp_attendance->out_time;
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;
                                    }

                                    if ($existed_emp_attendance->in_time && !$existed_emp_attendance->out_time && ($existed_emp_attendance->in_time != $access_time)) {


                                        $existed_in_time = strtotime($existed_emp_attendance->in_time);//10:01:00 AM
                                        $given_access_time = strtotime($access_time);// 11:50:00 AM

                                        $difference = (($given_access_time - $existed_in_time) / 60);

                                        if ($difference >= 10) {// out time must be more than 10 mins from in time
                                            //  \Log::info('updated ' . $get_user->id . ' ==> ' . $access_time);

                                            $existed_emp_attendance->user_id = $get_user->id;
                                            $existed_emp_attendance->out_time = $access_time;
                                            $existed_emp_attendance->out_access_id = $access_id;
                                            $existed_emp_attendance->out_device_id = $unit_id;
                                            $existed_emp_attendance->present_date = $attendance_date;
                                            $existed_emp_attendance->present_date_time = $attendance_date . ' ' . $access_time;
                                            $existed_emp_attendance->present_year = date('Y', strtotime($attendance_date));
                                            $existed_emp_attendance->present_month = date('m', strtotime($attendance_date));
                                            $existed_emp_attendance->present_day = date('d', strtotime($attendance_date));
                                            $existed_emp_attendance->site_id = $site_id;
                                            $existed_emp_attendance->save();
                                            $emp_updated[$get_user->id] = $existed_emp_attendance->id;

                                         //   $site = GlobalSiteInfo::whereId($site_id)->first();

                                            if ($site && $site_setting->emp_out_sms && ($attendance_date == $today)) {// out sms
                                        //    if ($site && ($attendance_date == $today)) {// out sms

                                                //check user sms off or on
                                                if (!$attendance_sms) {
                                                    $issue = new    IssueDetail();
                                                    $issue->username = $biometricNumber;
                                                    $issue->issuer_type = 'site';
                                                    $issue->issue_type = 'sms';
                                                    $issue->issue_details = "Employee SMS Off Individually";
                                                    $issue->access_time = $access_time;
                                                    $issue->attendance_date = $attendance_date;
                                                    $issue->device_id = $unit_id;
                                                    $issue->access_id = $access_id;
                                                    $issue->site_id = $site_id;
                                                    $issue->save();
                                                    continue;

                                                }


                                                $sms_txt = $get_user->first_name . ' ' . $get_user->last_name;

                                           

                                                $sms_txt .= ', ' . 'Out Time: ' . date('g:i A', strtotime($access_time));
                                                $sms_txt .= ', ' . 'Attendance Date: ' . date('d-m-Y', strtotime($attendance_date));
                                            //    $sms_txt .= ', ' . 'Regards: ' . $site_setting->short_name;
                                          

                                                $sms_txt .= ', ' . 'Regards: ' . $regards_title;

                                                $att_data_for_queue = [];
                                                $att_data_for_queue['att_user_type'] = 'employee';
                                                $att_data_for_queue['att_type'] = 'out';//in or out
                                                $att_data_for_queue['att_table_id'] = $existed_emp_attendance->id;


                                                if (!$this->sendAttendanceSms1([$get_user->contact_number], $sms_txt, $site_id, $att_data_for_queue)) {

                                                    $issue = new IssueDetail();
                                                    $issue->username = $biometricNumber;
                                                    $issue->issuer_type = 'site';
                                                    $issue->issue_type = 'attendance';
                                                    $issue->issue_details = 'sendAttendanceSms returns false';
                                                    $issue->access_time = $access_time;
                                                    $issue->attendance_date = $attendance_date;
                                                    $issue->device_id = $unit_id;
                                                    $issue->access_id = $access_id;
                                                    $issue->site_id = $site_id;
                                                    $issue->save();
                                                    continue;
                                                }
                                                $existed_emp_attendance->out_sms_id = 1;
                                                $existed_emp_attendance->save();
                                                continue;

                                            } else {
                                                $issue = new IssueDetail();
                                                $issue->username = $biometricNumber;
                                                $issue->issuer_type = 'site';
                                                $issue->issue_type = 'sms';
                                                $issue->issue_details = 'Emp Out Sms Off Or Attendance Date and Today is not same. Site:' . $site->id . ' emp_out_sms:' . $site_setting->emp_out_sms . ' Attendance Date:' . $attendance_date . ' Today:' . $today;
                                              //  $issue->issue_details = 'Emp Out Sms Off Or Attendance Date and Today is not same. Site:' . $site->id . ' emp_out_sms:' . ' Attendance Date:' . $attendance_date . ' Today:' . $today;
                                                $issue->access_time = $access_time;
                                                $issue->attendance_date = $attendance_date;
                                                $issue->device_id = $unit_id;
                                                $issue->access_id = $access_id;
                                                $issue->site_id = $site_id;
                                                $issue->save();
                                                continue;
                                            }

                                        } else {
                                            $issue = new IssueDetail();
                                            $issue->username = $biometricNumber;
                                            $issue->issuer_type = 'site';
                                            $issue->issue_type = 'attendance';
                                            $issue->issue_details = "Difference: " . $difference . " Access Time " . $access_time . ' Existed In Time:' . $existed_emp_attendance->in_time . ' must be 10 min or more';
                                            $issue->access_time = $access_time;
                                            $issue->attendance_date = $attendance_date;
                                            $issue->device_id = $unit_id;
                                            $issue->access_id = $access_id;
                                            $issue->site_id = $site_id;
                                            $issue->save();
                                            continue;
                                        }
                                    } else {
                                        $issue = new IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->issuer_type = 'site';
                                        $issue->issue_type = 'attendance';
                                        $issue->issue_details = $existed_emp_attendance->id . "- In:" . $existed_emp_attendance->in_time . ' Out:' . $existed_emp_attendance->out_time . ' Opposite of : In Found and Out not found And In and out not same';
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;
                                    }

                                } else {// dates att not found- add in time

                                    //check if off day and att_allowed
                                    $off_day_att = false;
                                    if (!$emp_shift_details->day_on && !$emp_shift_details->att_allowed) {


                                        $issue = new IssueDetail();
                                        $issue->username = $biometricNumber;
                                        $issue->issue_type = 'attendance';
                                        $issue->issuer_type = 'site';
                                        $issue->issue_details = "Off day and attendance not allowed";
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();
                                        continue;
                                    }
                                    if (!$emp_shift_details->day_on && $emp_shift_details->att_allowed) {
                                        $off_day_att = true;
                                    }
                                    $get_late_status = $this->checkIsLate($get_user, $access_time, $emp_shift_details, $emp_shifts[0]);
                                 //   $site = GlobalSiteInfo::whereId($site_id)->first();

                                    if ($this->isAttendanceInvalid($access_time, $emp_shift_details)) {// intime must be less than 60 mins

                                        $att_time_should_be_min = $this->minusMinutesToTime($emp_shift_details->in_time, $emp_shift_details->in_time_allowed_min);

                                        $issue = new IssueDetail();
                                        $issue->issue_type = 'attendance';
                                        $issue->issuer_type = 'site';
                                        $issue->username = $biometricNumber;
                                        $issue->issue_details = 'Minimum: ' . date('g:i A', strtotime($att_time_should_be_min)) . ' But Given In time ' . date('g:i A', strtotime($access_time));
                                        $issue->access_time = $access_time;
                                        $issue->attendance_date = $attendance_date;
                                        $issue->device_id = $unit_id;
                                        $issue->access_id = $access_id;
                                        $issue->site_id = $site_id;
                                        $issue->save();

                                        continue;
                                    }

                                    $emp_attendance->user_id = $get_user->id;
                                    $emp_attendance->site_shift_details_id = $emp_shift_details->id;
                                    $emp_attendance->present_type = 'device';
                                    $emp_attendance->in_access_id = $access_id;
                                    $emp_attendance->in_device_id = $unit_id;
                                    $emp_attendance->in_time = $access_time;
                                    $emp_attendance->present_date = $attendance_date;
                                    $emp_attendance->present_date_time = $attendance_date . ' ' . $access_time;
                                    $emp_attendance->present_year = date('Y', strtotime($attendance_date));
                                    $emp_attendance->present_month = date('m', strtotime($attendance_date));
                                    $emp_attendance->present_day = date('d', strtotime($attendance_date));
                                    $emp_attendance->late_status = $get_late_status;
                                    $emp_attendance->off_day_att = $off_day_att;
                                    $emp_attendance->site_id = $site_id;
                                    $emp_attendance->save();
                                    $emp_saved[$get_user->id] = $emp_attendance->id;

                                 //   if ($site && ($attendance_date == $today)) {// in sms
                                    if ($site && $site_setting->emp_in_sms && ($attendance_date == $today)) {// in sms


                                        //check user sms off or on
                                        if (!$attendance_sms) {
                                            $issue = new    IssueDetail();
                                            $issue->username = $biometricNumber;
                                            $issue->issuer_type = 'site';
                                            $issue->issue_type = 'sms';
                                            $issue->issue_details = "SMS Off individually";
                                            $issue->access_time = $access_time;
                                            $issue->attendance_date = $attendance_date;
                                            $issue->device_id = $unit_id;
                                            $issue->access_id = $access_id;
                                            $issue->site_id = $site_id;
                                            $issue->save();
                                            continue;

                                        }


                                        $sms_txt = $get_user->first_name . ' ' . $get_user->last_name;
                                        $sms_txt .= ', ' . 'In Time: ' . date('g:i A', strtotime($access_time));
                                        $sms_txt .= ', ' . 'Attendance Date: ' . date('d-m-Y', strtotime($attendance_date));
                                    
                                        $sms_txt .= ', ' . 'Regards: ' . $regards_title;

                                        $att_data_for_queue = [];
                                        $att_data_for_queue['att_user_type'] = 'employee';
                                        $att_data_for_queue['att_type'] = 'in';//in or out
                                        $att_data_for_queue['att_table_id'] = $emp_attendance->id;

                                        if (!$this->sendAttendanceSms1([$get_user->contact_number], $sms_txt, $site_id, $att_data_for_queue)) {

                                            $issue = new    IssueDetail();
                                            $issue->username = $biometricNumber;
                                            $issue->issuer_type = 'site';
                                            $issue->issue_type = 'attendance';
                                            $issue->issue_details = 'sendAttendanceSms returns false';
                                            $issue->access_time = $access_time;
                                            $issue->attendance_date = $attendance_date;
                                            $issue->device_id = $unit_id;
                                            $issue->access_id = $access_id;
                                            $issue->site_id = $site_id;
                                            $issue->save();
                                            continue;
                                        }

                                        $emp_attendance->in_sms_id = 1;
                                        $emp_attendance->save();
                                    }

                                }
                            } else {// no shift details found in site_shift_details table

                                $issue = new IssueDetail();
                                $issue->username = $biometricNumber;
                                $issue->issue_type = 'attendance';
                                $issue->issuer_type = 'site';
                                $issue->issue_details = "No shift details- employee. academic_shift_id:" .
                                    ($emp_shifts[0]->academic_shift_id ?? 'n/a') . "academic_period_type_id" .
                                    ($get_period_type_duration->academic_period_type_id ?? 'n/a');
                                $issue->access_time = $access_time;
                                $issue->attendance_date = $attendance_date;
                                $issue->device_id = $unit_id;
                                $issue->access_id = $access_id;
                                $issue->site_id = $site_id;
                                $issue->save();
                                continue;

                            }


                        }
                    } else {// no shift found for the emp

                        $issue = new    IssueDetail();
                        $issue->username = $biometricNumber;
                        $issue->issue_type = 'attendance';
                        $issue->issuer_type = 'site';
                        $issue->issue_details = "No shift assigned to employee:";
                        $issue->access_time = $access_time;
                        $issue->attendance_date = $attendance_date;
                        $issue->device_id = $unit_id;
                        $issue->access_id = $access_id;
                        $issue->site_id = $site_id;
                        $issue->save();
                        continue;
                    }
                } else {
                    $issue = new    IssueDetail();
                    $issue->username = $biometricNumber;
                    $issue->issue_type = 'attendance';
                    $issue->issuer_type = 'site';
                    $issue->issue_details = "Not student not employee";
                    $issue->access_time = $access_time;
                    $issue->attendance_date = $attendance_date;
                    $issue->device_id = $unit_id;
                    $issue->access_id = $access_id;
                    $issue->site_id = $site_id;
                    $issue->save();
                    continue;
                }

            } else {

                $issue = new    IssueDetail();
                $issue->username = $biometricNumber;
                $issue->issue_type = 'attendance';
                $issue->issuer_type = 'site';
                $issue->issue_details = $biometricNumber . " UserId not found";
                $issue->access_time = $access_time;
                $issue->attendance_date = $attendance_date;
                $issue->device_id = $unit_id;
                $issue->access_id = $access_id;
                $issue->site_id = 0;
                $issue->save();

                $message = $biometricNumber . " UserId not found";

            }

            $now = Carbon::now();
            $the_device_log->executed_status = 1;
            $the_device_log->executed_time = $now->toDateTimeString();
            $the_device_log->executed_message = 'End Of Line: ' . $message . 'previous:' . $the_device_log->executed_messag;
            $the_device_log->save();

        }//foreach end

        return [$data_saved, $data_updated, $emp_saved, $emp_updated];
    }


    private function checkIsLate($get_user, $access_time1, $shift_details, $emp_shift = null)
    {

        $late = false;
        $in_time = strtotime($shift_details->in_time);
        $access_time = strtotime($access_time1);

        if ($get_user->user_type == 'student') {

            if ($access_time > $in_time) {
                $late = true;
            }

            //check shift details grace
            if ($shift_details->in_time_grace) {

                $grace_min = $shift_details->in_time_grace;
                $final_in_time = date("H:i:s", strtotime('+' . $grace_min . ' minutes', $in_time));

                if ($access_time1 <= $final_in_time) {
                    $late = false;
                }
            }

            return $late;


        } elseif ($get_user->user_type == 'employee') {


            if ($access_time > $in_time) {
                $late = true;
            }

            if ($emp_shift->flaxibility_present) {
                $late = false;
            } else {
                //check emp shift wise grace
                if ($emp_shift->in_time_grace) {
                    $grace_min = $emp_shift->in_time_grace;

                    $final_in_time = date("H:i", strtotime('+' . $grace_min . ' minutes', $in_time));

                    if ($access_time <= $final_in_time) {
                        $late = false;
                    }
                }
                //check shift details grace
                if ($shift_details->in_time_grace) {
                    $grace_min = $shift_details->in_time_grace;
                    $final_in_time = date("H:i:s", strtotime('+' . $grace_min . ' minutes', $in_time));
                    if ($access_time1 < $final_in_time) {
                        $late = false;
                    }
                }
            }
            return $late;
        }
    }


    private function minusMinutesToTime($time, $minutes)
    {

        try {
            $org_time = $time;
            $min_minus = $minutes;


            //   $date = date("Y-m-d H:i:s");
            $time = strtotime($org_time);
            $time = $time - ($min_minus * 60);
            $newTime = date("H:i:s", $time);//10:00:00


            return $newTime;


        } catch (Exception $exception) {

            $issue = new    IssueDetail();
            $issue->issue_type = 'OrganizeSavedDeviceLogTrait';
            $issue->issuer_type = 'edu';
            $issue->issue_details = "error in OrganizeSavedDeviceLogTrait(): minusMinutesToTime() : " . $exception->getMessage();

            return $time;

        }

    }


    private function isAttendanceInvalid($a_time, $the_site_shift)
    {


        $in_time_allowed_min = $the_site_shift->in_time_allowed_min;

        $shift_time = strtotime($the_site_shift->in_time);//10:01:00 AM
        //   $shift_time = strtotime('10:00:00');//10:01:00 AM
        $given_access_time = strtotime($a_time);
        //$given_access_time = strtotime('08:50:00')                                      ;

        $difference = (($shift_time - $given_access_time) / 60);


        //  dd(($in_time_allowed_min != 0 || $in_time_allowed_min != null) && $difference > 0  && ($difference > $in_time_allowed_min));

        // dd('s t: '.$the_site_shift->in_time .' acc t: '.$a_time .' =>'.$difference);

        if (($in_time_allowed_min != 0 || $in_time_allowed_min != null) && $difference > 0 && ($difference > $in_time_allowed_min)) {
            return true;// in valid
        }

        return false;// valid

    }


    public function sendAttendanceSms1($numbers_array, $sms_txt, $site_id, $att_data_for_queue)
    {
        $sms_type = 'text';
        // first check the site has sms remaining balance

        $sms_mem_data = $this->getSmsRelatedSiteMembershipData1($site_id);
        $sms_balance = $sms_mem_data[0];
        $per_sms_cost = $sms_mem_data[1];
        $sms_bearer = $sms_mem_data[2];
        $sms_bearer_id = $sms_mem_data[3];
        $sms_send_type = $sms_mem_data[4];
        $sms_send_company = $sms_mem_data[5];

        $sms_count = $this->checkSmsCount($sms_txt);

        if ($sms_count == 0) {
            $issue = new  IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issuer_type = 'site';
            $issue->site_id = $site_id;
            $issue->save();
            return false;
        }


        $total_numbers = count($numbers_array);
        $sms_balance_needed = ($sms_count * $per_sms_cost * $total_numbers);

        $sms_balance = $this->getSmsBalanceForSite($sms_bearer, $sms_bearer_id);

        if ($sms_balance <= $sms_balance_needed) {//sms balance short
            
            $issue = new  IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issuer_type = 'site';
            $issue->site_id = $site_id;
            $issue->issue_details = 'Balance not available';
            $issue->save();
            return false;
        }

        $sms_data = [];
        $sms_data['sms_txt'] = $sms_txt;
        $sms_data['sms_bearer'] = $sms_bearer;
        $sms_data['sms_bearer_id'] = $sms_bearer_id;
        $sms_data['per_sms_cost'] = $per_sms_cost;
        $sms_data['sms_count'] = $sms_count;
        $sms_data['total_sms_charges'] = $sms_balance_needed;
        $sms_data['sms_type'] = $sms_type;
        $sms_data['sms_company'] = $sms_send_company;

        $sms_data['sms_masking'] = $sms_send_type == 'non_masking' ? null : $sms_send_type;
        $sms_data['att_user_type'] = $att_data_for_queue['att_user_type'];
        $sms_data['att_type'] = $att_data_for_queue['att_type'];
        $sms_data['att_table_id'] = $att_data_for_queue['att_table_id'];

        $cut_amount = $this->cutSmsBalance($sms_data['total_sms_charges'], $sms_data['sms_bearer'], $sms_data['sms_bearer_id']);
        dispatch(new SendAttSmsJob($numbers_array, $sms_data));

        return true;
    }


    public function getSmsRelatedSiteMembershipData1($site_id)
    {


        $site_membership = SiteMembership::where('site_id', $site_id)->where('status', 1)->first();

        // dd($site_membership);

        $sms_balance = $site_membership->sms_balance ?? 0;
        $per_sms_cost = $site_membership->per_sms_cost ?? 0.00;
        $sms_bearer = $site_membership->sms_bearer ?? 0;
        $sms_bearer_id = $site_membership->sms_bearer_id ?? 0;
        $sms_send_type = $site_membership->sms_send_type ?? 'non_masking';
        $sms_send_company = $site_membership->sms_send_company ?? null;


        return [$sms_balance, $per_sms_cost, $sms_bearer, $sms_bearer_id, $sms_send_type, $sms_send_company];

    }


}