<?php

namespace App\Notifications\Site;


use App\Models\Site\Notice\Notice;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class NoticeNotification extends Notification implements ShouldQueue
{
    use Queueable;
    public $tries = 1;


    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $notice;
    public $route;
    public function __construct(Notice $notice,$route)
    {
        $this->notice=$notice;
        $this->route=$route;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

/*
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Hey user, New post availabe')
            ->greeting('Hello' , 'Subscriber')
            ->line('There is a new post , hope you will like it')
            ->line('Post title : '.$this->post->title) //Send with post title
            ->action('Read Post' , url(route('post' , $this->post->slug))) //Send with post url
            ->line('Thank you for being with us!');
    }*/

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        // \Log::info('UserMessageNotification constructed with message ID: ' . $message->id);
        return [
            'id'=>$this->notice->id,
            'link'=>$this->route.'/'.$this->id,//route('site-notice-view',[$this->id]),
            'title' => $this->notice->notice_title,
            'data' => $this->notice->notice_description,
            'image_link' => $this->notice->files[0]->path ?? null,
        ];
    }
}
