<?php

namespace App\Notifications\EmployeeLeaveApplication;

use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class EmployeeLeaveApplicationApproveNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $employeeLeaveHistory;
    public $route;

    public function __construct(SiteEmployeeLeaveHistory $employeeLeaveHistory, $route)
    {
        //dd( $siteStudentFeeDemandSlipDetails);
        $this->employeeLeaveHistory=$employeeLeaveHistory;

        $this->route=$route;
       // dd('kooo');
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        $from_date =  $this->employeeLeaveHistory['form_date'];
        $to_date =  $this->employeeLeaveHistory['to_date'];

        if($this->employeeLeaveHistory['employee_spend_leave_days']==1){
           $data=$this->employeeLeaveHistory['employee_name'].", your leave application for 1 day (on ".$from_date.") has been approved.";
        }else{
           $data=$this->employeeLeaveHistory['employee_name'].", your leave application for ".$this->employeeLeaveHistory['employee_spend_leave_days']." days (from ".$from_date." to ".$to_date.") has been approved.";
        }

         return [
             'id'=>$this->employeeLeaveHistory->id,
             'link'=>$this->route.'/'.$this->id,//route('site-notice-view',[$this->id]),
             'title' => 'Your leave has been approved',
             'data' => $data
         ];

    }
}
