<?php

namespace App\Notifications\EmployeeDutyApplication;

use App\Models\Site\EmployeeDuty\SiteEmployeeDutyHistory;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Notice\Notice;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class EmployeeDutyApplicationNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $employeeDutyHistory;
    public $route;

    public function __construct(SiteEmployeeDutyHistory $employeeDutyHistory, $route)
    {
        //dd( $siteStudentFeeDemandSlipDetails);
        $this->employeeDutyHistory=$employeeDutyHistory;

        $this->route=$route;
       // dd('kooo');
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
//        return $this->siteStudentFeeDemandSlipDetails;

//        $fee_fine = SiteStudentFeeFine::where('site_student_fee_payment_history_id', $this->siteStudentFeePaymentHistory->id)->get();
//        $total_fine = 0;
//        if(count($fee_fine)){
//            foreach ($fee_fine as $key => $value){
//                $total_fine+= $value->fine_amount;
//            }
//        }
//
//        $total_amount = $this->siteStudentFeePaymentHistory->total_amount + $total_fine;

         return [
             'id'=>$this->employeeDutyHistory->id,
             'link'=>$this->route.'/'.$this->id,//route('site-notice-view',[$this->id]),
             'title' => 'Duty Approved',
             'data' => 'Duty Approved',
         ];

    }
}
