<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use App\Models\Site\Student\Student;
use App\Models\User\User;
use App\Models\ProjectModel;
use App\Models\Site\Employee\Employee;

class UserMessage extends ProjectModel
{
    protected $table='user_messages';
    public $timestamps = true;

    const User_id ='user_id';
    const Created_by = 'created_by';
    const Site_id = 'site_id';
    const Title = 'title';
    const Message = 'message';
    const Message_type_key = 'message_type_key';
    const Category = 'category';


    protected $fillable = [
        self::User_id,
        self::Created_by,
        self::Site_id,
        self::Title,
        self::Message,
        self::Message_type_key,
        self::Category
    ];

    public $ownFields = [
        self::User_id,
        self::Created_by,
        self::Site_id,
        self::Title,
        self::Message,
        self::Message_type_key,
        self::Category
    ];

    public function creator()
    {
        return $this->belongsTo(Employee::class, 'created_by');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }



}
