<?php

namespace App\Models\Teachers;

use App\Models\Department\Department;
use App\Models\Designation\Designation;
use App\Models\ProjectModel;
use App\Models\Shift\Shift;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;


class TeacherHistory extends Model
{
    const USER = 'user_id';
    const DEPARTMENT = 'department_id';
    const DEPTJOINDATE = 'dept_join_date';
    const SHIFT = 'shift_id';
    const STATUS ='status';


    public $timestamps = false;

    protected $fillable= [
        self::USER,
        self::DEPARTMENT,
        self::STATUS,
        self::DEPTJOINDATE,
        self::SHIFT,

    ];

    /**
     * last updated shift for an employee
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

}

