<?php

namespace App\Models\SubjectGroupConditionSetting;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\Site\Exam\GlobalSiteSubjectExaminationMark;

use Illuminate\Database\Eloquent\Model;

class GlobalSubjectGroupConditionSetting extends Model
{
    protected $appends = array('academic_class_groups','academic_subject_conditions', 'subject_name');

    protected $guarded = array();
    public static $rules = array();




    protected $table = 'site_subject_group_condition_settings';


    const Academic_group_id = 'academic_group_id'; //
    const ACADEMIC_SUBJECT_ID = 'academic_subject_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_GROUP_IDS = 'academic_class_group_ids';
    const ACADEMIC_SUBJECT_CONDITION_IDS = 'academic_subject_condition_ids';
    const Academic_subject_class_exam_condition_id = 'academic_subject_class_exam_condition_id';
    const Exam_dependent_academic_subject_id = 'exam_dependent_academic_subject_id';

    const Result_show_in_table_bellow = 'result_show_in_table_bellow';
    const Subject_position = 'subject_position';

    const SUBJECT_CODE = 'subject_code';
    const Site_id = 'site_id';
    const NOTE = 'note';
    const STATUS = 'status';

    public $timestamps = TRUE;

    protected $fillable = [
        self::Academic_group_id,
        self::ACADEMIC_SUBJECT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_GROUP_IDS,
        self::ACADEMIC_SUBJECT_CONDITION_IDS,

        self::Result_show_in_table_bellow,
        self::Subject_position,

        self::Academic_subject_class_exam_condition_id,
        self::Exam_dependent_academic_subject_id,
        self::SUBJECT_CODE,
        self::NOTE,
        self::Site_id,
        self::STATUS
    ];

    public $ownFields = [
        self::Academic_group_id,
        self::ACADEMIC_SUBJECT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_GROUP_IDS,

        self::Result_show_in_table_bellow,
        self::Subject_position,

        self::ACADEMIC_SUBJECT_CONDITION_IDS,
        self::Academic_subject_class_exam_condition_id,
        self::Exam_dependent_academic_subject_id,
        self::SUBJECT_CODE,
        self::NOTE,
        self::Site_id,
        self::STATUS
    ];

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }
    public function academicDepartment()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }


    public function getSubjectNameAttribute()
    {
        return  $this->attributes['subject_name']=  ($this->academicSubject->subject_name ?? '');

    }

    public function academicSubject()
    {
        return $this->belongsTo(AcademicSubject::class);
    }


    public function globalSiteSubjectExaminationMark()
    {
        return $this->hasMany(GlobalSiteSubjectExaminationMark::class, 'site_subject_group_condition_setting_id');
    }



    public function academicSubjectClassExamCondition()
    {
        return $this->belongsTo(AcademicSubjectClassExamCondition::class, 'academic_subject_class_exam_condition_id');

    }

    public function siteSubjectExaminationMark()
    {
        return $this->hasMany(GlobalSiteSubjectExaminationMark::class, 'site_subject_group_condition_setting_id');
    }
   

    public function examDependentAcademicSubject()
    {
        return $this->belongsTo(AcademicSubject::class, 'exam_dependent_academic_subject_id');
    }


    //    protected $appends = array(['academic_class_groups','academic_subject_conditions');


    public function getAcademicClassGroupsAttribute()
    {
        // return $this->belongsTo(AcademicSubject::class);

        return  $this->attributes['academic_class_groups']=  AcademicClassGroup::whereIn('id',explode(',', $this->academic_class_group_ids))->get();

    }

    public function getAcademicSubjectConditionsAttribute()
    {
        // return $this->belongsTo(AcademicSubject::class);

        return  $this->attributes['academic_subject_conditions']= SubjectCondition::whereIn('id',explode(',', $this->academic_subject_condition_ids))->get();

    }


}
