<?php

namespace App\Models\SiteGroup\Site\Student;

use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model
{
    use Translatable, SoftDeletes;

    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';
    public $timestamps = true;


    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';
    protected $dates = ['deleted_at'];
    protected $appends = array('full_name', 'student_full_roll_number');


    public function __construct(array $attributes = [])
    {

    }


    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];


    const USERNAME = 'username';
    const EMAIL = 'email';
    const USER_TYPE = 'user_type';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER_NAME = 'father_name';
    const MOTHER_NAME = 'mother_name';
    const SPOUSE_NAME = 'spouse_name';
    const PASSWORD = 'password';
    const LAST_LOGIN = 'last_login';
    const NAME_NATIVE_LANGUAGE = 'name_native_language';
    const CONTACT_NUMBER = 'contact_number';
    const BLOOD_GROUP_ID = 'blood_group_id';
    const FATHER_OCCUPATION_ID = 'father_occupation_id';
    const FATHER_YEARLY_INCOME = 'father_yearly_income';
    const FATHER_CONTACT_NUMBER = 'father_contact_number';
    const FATHER_EMAIL = 'father_email';
    const MOTHER_OCCUPATION_ID = 'mother_occupation_id';
    const MOTHER_YEARLY_INCOME = 'mother_yearly_income';
    const MOTHER_CONTACT_NUMBER = 'mother_contact_number';
    const MOTHER_EMAIL = 'mother_email';
    const PRESENT_COUNTRY_ID = 'present_country_id';
    const PRESENT_DIVISION_ID = 'present_division_id';
    const PRESENT_DISTRICT_ID = 'present_district_id';
    const PRESENT_THANA_ID = 'present_thana_id';
    const ADDRESS = 'address';
    const PERMANENT_COUNTRY_ID = 'permanent_country_id';
    const PERMANENT_DIVISION_ID = 'permanent_division_id';
    const PERMANENT_DISTRICT_ID = 'permanent_district_id';
    const PERMANENT_THANA_ID = 'permanent_thana_id';
    const PERMANENT_ADDRESS = 'permanent_address';
    const GENDER_ID = 'gender_id';
    const RELIGION_ID = 'religion_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_RESIDANCE_ID = 'academic_residence_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_STUDENT_CATEGORY_ID = 'academic_student_category_id';
    const ACADEMIC_STUDENT_TYPE_ID = 'academic_student_type_id';
    const ACADEMIC_STUDENT_ADMISSION_TYPE_ID = 'academic_student_admission_type_id';
    const ACADEMIC_QUATA_ID = 'academic_quata_id';
    const STUDENT_REGISTRATION_NUMBER = 'student_registration_number';
    const BOARD_REGISTRATION_NUMBER = 'board_registration_number';
    const RELIGION_SUBJECT_ID = 'religion_subject_id';
    const COMPULSORY_SUBJECT_IDS = 'compulsory_subject_ids';
    const OPTIONAL_SUBJECT_IDS = 'optional_subject_ids';

    const ACADEMIC_SUBJECT_IDs = 'academic_subject_ids';
//    const GENERAL_MARKINGLESS_SUBJECT_IDs = 'general_markingless_subject_ids';
    const SELECTIVE_MARKINGLESS_SUBJECT_IDs = 'selective_markingless_subject_ids';

    const GUARDIAN_STUDENT_RELATION_ID = 'guardian_student_relation_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const STUDENT_ROLL_NUMBER = 'student_roll_number';
    const PROFESSION = 'profession';
    const LOCAL_GUARDIAN_USER_ID = 'local_guardian_user_id';
    const DEPARTMENT_ID = 'department_id';
    const DESIGNATION_ID = 'designation_id';
    const EMP_CATEGORY_ID = 'emp_category_id';
    const EMP_POSITION_ID = 'emp_position_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const BIOMETRIC_ID = 'biometric_id';
    const DEPT_JOIN_DATE = 'dept_join_date';
    const PHONE = 'phone';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const NID_NUMBER = 'nid_number';
    const PASSPORT_NO = 'passport_no';
    const BIRTH_CERTIFICATE_NO = 'birth_certificate_no';
    const STATUS = 'status';
    const REMEMBER_TOKEN = 'remember_token';
    const DATE_OF_BIRTH = 'date_of_birth';
    const DELETED_AT = 'deleted_at';

    const Created_by = 'created_by';
    const Updated_by = 'updated_by';

    const NATIONALITY = 'nationality';
    const INSTITUTE_JOINING_DATE = 'institute_joining_date';
    const NTRC_REGISRATION_NUMBER = 'ntrc_registration_number';
    const Student_roll_number_prefix = 'student_roll_number_prefix';

    const Present_id_card_code = 'present_id_card_code';
    const Ex_id_card_code = 'ex_id_card_code';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::SPOUSE_NAME,
        self::MOTHER_NAME,
        self::FATHER_NAME,
        self::PERMANENT_ADDRESS
    ];



    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');

    }

    public function getStudentFullRollNumberAttribute()
    {
        return $this->attributes['student_full_roll_number'] = ($this->student_roll_number_prefix ?? '') . ($this->student_roll_number);
    }

}
