<?php

namespace App\Models\SiteGroup\Site\Employee;

use App\Models\SiteGroup\Site\SiteGroupSitesModel;
use App\Models\User\GlobalUser;

class SiteGroupEmployeeAttendance extends SiteGroupSitesModel
{
    protected $table='site_employee_attendances';
    public $timestamps = true;


    const USER = 'user_id';
    const ACADEMIC_SHIFT_DETAILS_ID = 'site_shift_details_id';
    const PRESENT_TYPE = 'present_type';
    const PRESENT_TYPE_ID = 'present_type_id';
    const IN_TIME = 'in_time';
    const OUT_TIME = 'out_time';
    const ATTENDANCE_DATE = 'present_date';
    const OFF_DAY_ATT = 'off_day_att';
    const NOTE = 'note';
    const ATTENDANCE_DATE_TIME = 'present_date_time';
    const ATTENDANCE_YEAR = 'present_year';
    const ATTENDANCE_MONTH = 'present_month';
    const ATTENDANCE_DAY = 'present_day';
    const LATE_STATUS = 'late_status';
    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';


    protected $fillable = [
        self::USER,
        self::ACADEMIC_SHIFT_DETAILS_ID,
        self::PRESENT_TYPE,
        self::PRESENT_TYPE_ID,
        self::IN_TIME,
        self::OUT_TIME,
        self::ATTENDANCE_DATE,
        self::ATTENDANCE_YEAR,
        self::ATTENDANCE_MONTH,
        self::ATTENDANCE_DAY,
        self::OFF_DAY_ATT,
        self::NOTE,
        self::ATTENDANCE_DATE_TIME,
        self::LATE_STATUS,
        self::CREATED_AT,
        self::UPDATED_AT,
    ];

    public function employee()//to get todays attancance
    {
        return $this->belongsTo(GlobalUser::class,'user_id');
    }

    public function shiftDetail()//to get todays attancance
    {
        return $this->belongsTo(SiteShiftDetails::class,'site_shift_details_id');
    }
}
