<?php

namespace App\Models\SiteGroup\Site\Employee;

use App\Models\Image\Photo;
use App\Models\Role\HasRoles;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\User\EmployeeHistory;
// use App\Models\SiteGroup\Site\Employee\EmployeeHistory;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model
{
    use Translatable, HasRoles, SoftDeletes;
    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';
    public $timestamps = true;

    protected $table = 'users';
    protected $dates = ['deleted_at'];

    protected $appends = array('full_name');

    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER_NAME = 'father_name';
    const MOTHER_NAME = 'mother_name';
    const SPOUSE_NAME = 'spouse_name';

    const ADDRESS = 'address';
    const PERMANENT_ADDRESS = 'permanent_address';
    // const Site_id = 'site_id';
    // const Alias = 'alias';

    // protected $fillable = [
    //     self::Site_id,
    //     self::Alias,
    // ];

    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::SPOUSE_NAME,
        self::MOTHER_NAME,
        self::FATHER_NAME,
        self::PERMANENT_ADDRESS
    ];

    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');

    }

    public function latestPhoto()
    {
        return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
    }


    public function empHistories()
    {
        return $this->hasOne(EmployeeHistory::class, 'user_id');
    }

    public function site()
    {
        return $this->belongsTo(GlobalSiteInfo::class,'site_id');
    }

}
