<?php

namespace App\Models\SiteGroup\Settings;

use App\Models\Academic\AcademicGroup;
use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGroup\SiteGroupGlobalModel;

class SiteGroupAcademicSettingsStore extends SiteGroupGlobalModel
{
    public $table = 'site_group_academic_settings_stores';

    public $timestamps = true;

    const ACADEMIC_GROUP_ID  = 'academic_group_id';
    const SITE_GROUP_ID  = 'site_group_id';
    const Academic_year_ids  = 'academic_year_ids';
    const ACADEMIC_CLASS_IDS  = 'academic_class_ids';
    const ACADEMIC_DEPARTMENT_IDS  = 'academic_department_ids';
    const ACADEMIC_CLASS_GROUP_IDS  = 'academic_class_group_ids';
    const ACADEMIC_SECTION_IDS = 'academic_section_ids';
    const ACADEMIC_GROUP_IDS = 'academic_group_ids';
    const ACADEMIC_SUBJECT_CONDITION_IDS  = 'academic_subject_condition_ids';
    const ACADEMIC_SUBJECT_IDS  = 'academic_subject_ids';
    const ACADEMIC_SESSION_IDS ='academic_session_ids';
    const ACADEMIC_VERSION_IDS ='academic_version_ids';
    const ACADEMIC_STUDENT_TYPE_IDS ='academic_student_type_ids';
    const STUDENT_CATEGORY_IDS  = 'student_category_ids';
    const SHIFT_IDS = 'shift_ids';
    const GENDER_IDS= 'gender_ids';
    const DESIGNATION_IDS= 'designation_ids';

    const Academic_session_type_ids= 'academic_session_type_ids';
    const Academic_student_category_ids= 'academic_student_category_ids';
    const Academic_admission_type_ids= 'academic_admission_type_ids';
    const Religion_ids= 'religion_ids';
    const Academic_residence_ids= 'academic_residence_ids';
    const Emp_exam_committee_position_ids= 'emp_exam_committee_position_ids';
    const Academic_result_grade_ids= 'academic_result_grade_ids';
    const Academic_result_primary_type_ids = 'academic_result_primary_type_ids';
    const Academic_result_combine_type_ids = 'academic_result_combine_type_ids';
    const ST_IN_SMS = 'st_in_sms';
    const ST_OUT_SMS = 'st_out_sms';
    const PRESENT_SMS_TEXT = 'present_sms_text';
    const Present_in_sms_text = 'present_in_sms_text';
    const Present_out_sms_text = 'present_out_sms_text';
    const Batch_present_status = 'batch_present_status';

    const Examination_ids = 'examination_ids';
    const Academic_exam_type_ids = 'academic_exam_type_ids';
    const Academic_result_system_ids = 'academic_result_system_ids';
    const Academic_subject_class_exam_condition_ids = 'academic_subject_class_exam_condition_ids';
    const Device_using_class_ids = 'device_using_class_ids';

    const Academic_calendar_head_ids  = 'academic_calendar_head_ids';
    const Academic_fee_head_ids= 'academic_fee_head_ids';
    const Academic_fee_group_ids= 'academic_fee_group_ids';
    const Academic_fee_sub_head_ids= 'academic_fee_sub_head_ids';
    const Academic_waiver_type_ids= 'academic_waiver_type_ids';
    const Academic_student_offer_type_ids= 'academic_student_offer_type_ids';
    const STATUS ='status';


    protected $fillable =[

        self::ACADEMIC_GROUP_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_DEPARTMENT_IDS,
        self::Academic_year_ids,
        self::ACADEMIC_CLASS_IDS,
        self::ACADEMIC_CLASS_GROUP_IDS,
        self::ACADEMIC_SECTION_IDS,
        self::ACADEMIC_GROUP_IDS,
        self::ACADEMIC_SUBJECT_CONDITION_IDS,
        self::ACADEMIC_SUBJECT_IDS,
        self::ACADEMIC_SESSION_IDS,
        self::ACADEMIC_VERSION_IDS,
        self::ACADEMIC_STUDENT_TYPE_IDS,
        self::STUDENT_CATEGORY_IDS,
        self::SHIFT_IDS,
        self::GENDER_IDS,
        self::DESIGNATION_IDS,

        self::Academic_session_type_ids,
        self::Academic_student_category_ids,
        self::Academic_admission_type_ids,
        self::Religion_ids,
        self::Academic_residence_ids,
        self::Emp_exam_committee_position_ids,
        self::Academic_result_grade_ids,
        self::Academic_result_primary_type_ids,
        self::Academic_result_combine_type_ids,
        self::ST_IN_SMS,
        self::ST_OUT_SMS,
        self::PRESENT_SMS_TEXT,
        self::Present_in_sms_text,
        self::Present_out_sms_text,
        self::Batch_present_status,
        self::Examination_ids,
        self::Academic_exam_type_ids,
        self::Academic_result_system_ids,
        self::Academic_subject_class_exam_condition_ids,
        self::Device_using_class_ids,

     //   self::Academic_calendar_head_ids,
        self::Academic_fee_head_ids,
        self::Academic_fee_group_ids,
        self::Academic_fee_sub_head_ids,
        self::Academic_waiver_type_ids,
        self::Academic_student_offer_type_ids,
        self::STATUS,

    ];
    public $ownfields = [
        self::ACADEMIC_GROUP_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_DEPARTMENT_IDS,
        self::Academic_year_ids,
        self::ACADEMIC_CLASS_IDS,
        self::ACADEMIC_CLASS_GROUP_IDS,
        self::ACADEMIC_SECTION_IDS,
        self::ACADEMIC_GROUP_IDS,
        self::ACADEMIC_SUBJECT_CONDITION_IDS,
        self::ACADEMIC_SUBJECT_IDS,
        self::ACADEMIC_SESSION_IDS,
        self::ACADEMIC_VERSION_IDS,
        self::ACADEMIC_STUDENT_TYPE_IDS,
        self::STUDENT_CATEGORY_IDS,
        self::SHIFT_IDS,
        self::GENDER_IDS,
        self::DESIGNATION_IDS,

      //  self::Academic_calendar_head_ids,
        self::Academic_session_type_ids,
        self::Academic_student_category_ids,
        self::Academic_admission_type_ids,
        self::Religion_ids,
        self::Academic_residence_ids,
        self::Emp_exam_committee_position_ids,
        self::Academic_result_grade_ids,
        self::Academic_result_primary_type_ids,
        self::Academic_result_combine_type_ids,
        self::ST_IN_SMS,
        self::ST_OUT_SMS,
        self::PRESENT_SMS_TEXT,
        self::Present_in_sms_text,
        self::Present_out_sms_text,
        self::Batch_present_status,
        self::Examination_ids,
        self::Academic_exam_type_ids,
        self::Academic_result_system_ids,
        self::Academic_subject_class_exam_condition_ids,
        self::Device_using_class_ids,

        self::Academic_fee_head_ids,
        self::Academic_fee_group_ids,
        self::Academic_fee_sub_head_ids,
        self::Academic_waiver_type_ids,
        self::Academic_student_offer_type_ids,
        self::STATUS
    ];

    public  function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class, 'academic_group_id', 'id');
    }
}
