<?php

namespace App\Models\SiteGroup\Exam;

use Illuminate\Database\Eloquent\Model;
use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\SiteGroup\SiteGroupGlobalModel;

class SiteGroupExaminationExamTypeSettingStore extends SiteGroupGlobalModel
{
    protected $table='site_group_examination_exam_type_setting_stores';
    protected $appends = array('examination_name');

    const Academic_group_id = 'academic_group_id';
    const Site_group_id = 'site_group_id';

    const Academic_year_id = 'academic_year_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_department_id = 'academic_department_id';

    const Examination_id = 'examination_id';
    const Academic_exam_type_id = 'academic_exam_type_id';
    const Direct_result_input = 'direct_result_input';
    const Retack_allow = 'retack_allow';
    const Exam_day = 'exam_day';
    const Position_show = 'position_show';
    const Type_access_owner = 'type_access_owner';
    const Site_ids = 'site_ids';
    const Status = 'status';
    
    const Routine_wise_exam_attendace = 'routine_wise_exam_attendace';
    const Site_attendace_permission = 'site_attendace_permission';
    const Site_exam_mark_entry_permission = 'site_exam_mark_entry_permission';
    const Examiner_exam_mark_entry_permission = 'examiner_exam_mark_entry_permission';
    const Exam_mark_entry_deadline = 'exam_mark_entry_deadline';


    protected $fillable = [
        self::Academic_group_id,
        self::Site_group_id,

        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,

        self::Examination_id,
        self::Academic_exam_type_id,
        self::Direct_result_input,
        self::Retack_allow,
        self::Exam_day,
        self::Position_show,
        self::Type_access_owner,
        self::Site_ids,
        self::Status,

        self::Routine_wise_exam_attendace,
        self::Site_attendace_permission,
        self::Site_exam_mark_entry_permission,
        self::Examiner_exam_mark_entry_permission,
        self::Exam_mark_entry_deadline,

    ];

    public $ownFields = [
        self::Academic_group_id,
        self::Site_group_id,

        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,

        self::Examination_id,
        self::Academic_exam_type_id,
        self::Direct_result_input,
        self::Retack_allow,
        self::Exam_day,
        self::Position_show,
        self::Type_access_owner,
        self::Site_ids,
        self::Status,
        
        self::Routine_wise_exam_attendace,
        self::Site_attendace_permission,
        self::Site_exam_mark_entry_permission,
        self::Examiner_exam_mark_entry_permission,
        self::Exam_mark_entry_deadline,

    ];



    //mutator
    public function getExaminationNameAttribute()
    {
        return  $this->attributes['examination_name']= $this->examination->examination_name;

    }


    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class);
    }

    public function examination()
    {
        return $this->belongsTo(Examination::class);
    }
}
