<?php

namespace App\Models\SiteGroup\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\SiteGroup\Settings\SiteGroupSubjectGroupConditionSettingStore;
use App\Models\SiteGroup\SiteGroupGlobalModel;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Database\Eloquent\Model;

class SiteGroupExamRoutineStore extends SiteGroupGlobalModel
{
    protected $table='site_group_exam_routine_stores';
    protected $appends = array('examination_name', 'exam_type_name');

    const Academic_group_id = 'academic_group_id';
    const Site_group_id = 'site_group_id';
    const Site_exam_declare_id = 'site_group_exam_declare_id';
    const Site_subject_group_condition_setting_id = 'site_group_subject_group_condition_setting_id';
    const Academic_subject_id = 'academic_subject_id';
    const Academic_exam_type_id = 'academic_exam_type_id';
    const Online_exam_status = 'online_exam_status';
    const Online_result_show_student = 'online_result_show_student';
    const Exam_start_date = 'exam_start_date';
    const Exam_end_date = 'exam_end_date';
    const Exam_start_time = 'exam_start_time';
    const Exam_end_time = 'exam_end_time';
    const Exam_duration = 'exam_duration';
    const Per_day_student = 'per_day_student';
    const Seat_plan_publish_for_employee = 'seat_plan_publish_for_employee';
    const Seat_plan_publish_for_student = 'seat_plan_publish_for_student';
    const Status = 'status';


    protected $fillable = [
        self::Academic_group_id,
        self::Site_group_id,
        self::Site_exam_declare_id,
        self::Online_exam_status,
        self::Online_result_show_student,
        self::Site_subject_group_condition_setting_id,
        self::Academic_subject_id,
        self::Academic_exam_type_id,
        self::Exam_start_date,
        self::Exam_end_date,
        self::Exam_start_time,
        self::Exam_end_time,
        self::Exam_duration,
        self::Per_day_student,
        self::Status,

    ];

    protected $ownFields = [
        self::Academic_group_id,
        self::Site_group_id,
        self::Site_exam_declare_id,
        self::Online_exam_status,
        self::Online_result_show_student,
        self::Site_subject_group_condition_setting_id,
        self::Academic_subject_id,
        self::Academic_exam_type_id,
        self::Exam_start_date,
        self::Exam_end_date,
        self::Exam_start_time,
        self::Exam_end_time,
        self::Exam_duration,
        self::Per_day_student,
        self::Status,

    ];

    public function getExaminationNameAttribute() {

        return  $this->attributes['examination_name']=  $this->examination->examination_name;

    }

    public function getExamTypeNameAttribute() {

        return  $this->attributes['exam_type_name']=  $this->academicExamType->marks_type;

    }

    public function examination()
    {
        return $this->belongsTo(Examination::class);

    }


    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class);

    }

    // public function subjectGroupConditionSetting()
    // {
    //     return $this->belongsTo(SubjectGroupConditionSetting::class, 'site_subject_group_condition_setting_id');

    // }

    public function siteGroupSubjectGroupConditionSettingStore()
    {
        return $this->belongsTo(SiteGroupSubjectGroupConditionSettingStore::class, 'site_group_subject_group_condition_setting_id');
    }

}
