<?php

namespace App\Models\Site\Web\ClassRoom;

use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteClassLessonReplyFeedback extends Model
{
    protected $table='site_class_lesson_reply_feedbacks';
    protected $appends = array('reply_edit');


    const Site_class_lesson_feedback_id = 'site_class_lesson_feedback_id';
    const Reply_by = 'reply_by';
    const Reply_detail = 'reply_detail';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::Site_class_lesson_feedback_id,
        self::Reply_by,
        self::Reply_detail,
        self::Site_id,
        self::Status,

    ];

    protected $ownFields = [
        self::Site_class_lesson_feedback_id,
        self::Reply_by,
        self::Reply_detail,
        self::Site_id,
        self::Status,

    ];

    public function getReplyEditAttribute()
    {
        return  $this->attributes['reply_edit']=  false;

    }

    public function user()
    {
        return $this->belongsTo(User::class, 'reply_by');
    }

}
