<?php

namespace App\Models\Site\TC;

use App\Models\Image\Photo;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class TcSetting extends SiteGlobalModel
{
    public $timestamps = false;
    protected $table='site_student_tc_settings';

    const SETTING_NAME = 'setting_name';
    const HEADING = 'heading';
    const BODY_STARTING = 'body_starting';
    const BODY_ENDIG = 'body_ending';
    const CONCLUSION = 'conclusion';
    const AUTHORITY_NAME = 'authority_name';
    const AUTHORITY_SIGNATURE = 'authority_signature';
    const CREATE_DATE = 'create_date';
    const CREATED_BY = 'created_by';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::SETTING_NAME,
        self::HEADING,
        self::BODY_STARTING,
        self::BODY_ENDIG,
        self::CONCLUSION,
        self::AUTHORITY_NAME,
        self::AUTHORITY_SIGNATURE,
        self::CREATE_DATE,
        self::CREATED_BY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS
    ];

    public $ownFields = [
        self::SETTING_NAME,
        self::HEADING,
        self::BODY_STARTING,
        self::BODY_ENDIG,
        self::CONCLUSION,
        self::AUTHORITY_NAME,
        self::AUTHORITY_SIGNATURE,
        self::CREATE_DATE,
        self::CREATED_BY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS
    ];

    public function photos()
    {
        return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
    }

//    public function photos()
//    {
//        return $this->hasMany(Photo::class, 'imageable_id');
//    }


}