<?php

namespace App\Models\Site\TC;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class SiteStudentTC extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_student_tc_histories';

    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STUDENT_HISTORY_ID = 'student_history_id';
    const TC_NO = 'tc_no';
    const REASON = 'reason';
    const GENERATE_DATE = 'generate_date';
    const Institute_left_date = 'institute_left_date';
    const Payment_complition_date = 'payment_complition_date';
    const DUE_AMOUNT = 'due_amount';
    const Passing_year = 'passing_year';
    const Completed_class = 'completed_class_id';
    const Promoted_class = 'promoted_class_id';
    const Examination_id = 'examination_id';
    const Reason_note = 'reason_note';
    const GPA = 'gpa';
    const Grade = 'grade';
    const Student_pass_fail_status = 'student_pass_fail_status';
    const Behaviour = 'behaviour';

    const STATUS = 'status';

    const Referance_prefix = 'referance_prefix';
    const Referance_number = 'referance_number';
    const Referance_suffix = 'referance_suffix';

    const TC_created_by = 'tc_created_by';
    const TC_updated_by = 'tc_updated_by';


    protected $fillable = [
        self::Reason_note,
        self::STUDENT_HISTORY_ID,
        self::Referance_prefix,
        self::Referance_number,
        self::Referance_suffix,
        self::TC_NO,
        self::REASON,
        self::GENERATE_DATE,
        self::DUE_AMOUNT,
        self::Institute_left_date,
        self::Payment_complition_date,
        self::Passing_year,
        self::Completed_class,
        self::Promoted_class,
        self::Examination_id,
        self::GPA,
        self::Grade,
        self::Student_pass_fail_status,
        self::Student_pass_fail_status,
        self::Behaviour,
        self::TC_created_by,
        self::TC_updated_by,
        self::STATUS
    ];

    public $ownFields = [
        self::SITE_ID,
        self::Reason_note,
        self::ACADEMIC_GROUP_ID,
        self::STUDENT_HISTORY_ID,
        self::Referance_prefix,
        self::Referance_number,
        self::Referance_suffix,
        self::TC_NO,
        self::REASON,
        self::GENERATE_DATE,
        self::DUE_AMOUNT,
        self::Institute_left_date,
        self::Payment_complition_date,
        self::Passing_year,
        self::Completed_class,
        self::Promoted_class,
        self::Examination_id,
        self::GPA,
        self::Grade,
        self::Student_pass_fail_status,
        self::Student_pass_fail_status,
        self::Behaviour,
        self::TC_created_by,
        self::TC_updated_by,
        self::STATUS
    ];
    protected $appends = array('promoted_class','completed_class');

    public function getPromotedClassAttribute()
    {
        return $this->attributes['promoted_class'] = AcademicClass::where('id', $this->promoted_class_id)->select('id', 'class_name')->first() ?? null;
    }
    public function getCompletedClassAttribute()
    {
        return $this->attributes['completed_class'] = AcademicClass::where('id', $this->completed_class_id)->select('id', 'class_name')->first() ?? null;
    }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);
    }

    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class, 'examination_id');
    }


}
