<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicFeeSubHead;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentAdmissionFeeGenerate extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table = 'site_student_admission_fee_generates';


    const Student_admission_list_id = 'site_student_admission_board_approve_id';
    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const Amount = 'amount';
    const Status = 'status';
    const Site_id = 'site_id';
    const Site_group_id = 'site_group_id';


    protected $fillable = [
        self::Student_admission_list_id,
        self::Academic_fee_sub_head_id,
        self::Amount,
        self::Site_id,
        self::Status,
        self::Site_group_id,
    ];


    public $ownFields = [
        self::Student_admission_list_id,
        self::Academic_fee_sub_head_id,
        self::Amount,
        self::Site_id,
        self::Status,
        self::Site_group_id,
    ];

    public function academicFeeSubHead()
    {
        return $this->belongsTo(AcademicFeeSubHead::class, 'academic_fee_sub_head_id');
    }
}
