<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicClassGroup;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class GlobalStudentRollCreateRange extends Model
{
    
    public $timestamps = true;
    protected $table = 'site_student_roll_create_ranges';
    protected $appends = array('group_name');

    const Site_student_admission_declare_id = 'site_student_admission_declare_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Academic_section_id = 'academic_section_id';
    const Start_roll = 'start_roll';
    const End_roll = 'end_roll';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';
   

    protected $fillable = [
        self::Site_student_admission_declare_id,
        self::Academic_shift_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_section_id,
        self::Start_roll,
        self::End_roll,
        self::Site_id,
        self::Academic_group_id,
    ];

    public $ownFields = [
        self::Site_student_admission_declare_id,
        self::Academic_shift_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_section_id,
        self::Start_roll,
        self::End_roll,
        self::Site_id,
        self::Academic_group_id,
    ];

    public function getGroupNameAttribute($value)
    {
        return $this->attributes['group_name'] = $this->academicClassGroup->group_name;
    }

    public function academicClassGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, 'academic_class_group_id');
    }


   
}
