<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicBoard;
use App\Models\Academic\AcademicSession;
use App\Models\Examinations\Examination;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteStudentAdmissionEducationQualification extends Model
{
    public $timestamps = true;
    protected $table = 'site_student_admission_education_qualifications';




    const Site_student_admission_application_id = 'site_student_admission_application_id';
    const Examination_id = 'examination_id';
    const Institution_name = 'institution_name';
    const Board_roll_number = 'board_roll_number';
    const Board_registration_number = 'board_registration_number';
    const Academic_board_id = 'academic_board_id';
    const Academic_session_id = 'academic_session_id';
    const Passing_year = 'passing_year';
    const Gpa_with_optional = 'gpa_with_optional';
    const Gpa_without_optional = 'gpa_without_optional';


    protected $fillable = [
        self::Site_student_admission_application_id,
        self::Examination_id,
        self::Institution_name,
        self::Board_roll_number,
        self::Board_registration_number,
        self::Academic_board_id,
        self::Academic_session_id,
        self::Passing_year,
        self::Gpa_with_optional,
        self::Gpa_without_optional,

    ];


    public $ownFields = [
        self::Site_student_admission_application_id,
        self::Institution_name,
        self::Examination_id,
        self::Board_roll_number,
        self::Board_registration_number,
        self::Academic_board_id,
        self::Academic_session_id,
        self::Passing_year,
        self::Gpa_with_optional,
        self::Gpa_without_optional,


    ];


    public function examination()
    {
        return $this->belongsTo(Examination::class, 'examination_id');
    }
    public function academicBoard()
    {
        return $this->belongsTo(AcademicBoard::class, 'academic_board_id');
    }
    public function academicSession()
    {
        return $this->belongsTo(AcademicSession::class, 'academic_session_id');
    }


}
