<?php

namespace App\Models\Site\Student\Promotion;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class GlobalStudentPromotionHistory extends Model
{

    public $timestamps = true;
    protected $table='student_promotion_histories';


    const USER_ID = 'user_id';
    const PREVIOUS_STUDENT_HISTORY_ID = 'previous_student_history_id';
    const PRESENT_STUDENT_HISTORY_ID = 'present_student_history_id';
    const DUE = 'due';
    const EXECUTION_DATE = 'execution_date';
    const ACTION_BY = 'action_by';
    const RESULT = 'result';
    const PROMOTION_TYPE = 'promotion_type';
    const ACTION_TYPE = 'action_type';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const PREVIOUS_STD_PROMOTION_HISTORY_ID = 'previous_std_promotion_history_id';
    const STATUS = 'status';


    protected $fillable = [
        self::USER_ID,
        self::PREVIOUS_STUDENT_HISTORY_ID,
        self::PRESENT_STUDENT_HISTORY_ID,
        self::DUE,
        self::EXECUTION_DATE,
        self::ACTION_BY,
        self::ACTION_TYPE,
        self::RESULT,
        self::PROMOTION_TYPE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::PREVIOUS_STD_PROMOTION_HISTORY_ID,
        self::STATUS
    ];

    public $ownFields = [
        self::USER_ID,
        self::PREVIOUS_STUDENT_HISTORY_ID,
        self::PRESENT_STUDENT_HISTORY_ID,
        self::DUE,
        self::EXECUTION_DATE,
        self::ACTION_BY,
        self::ACTION_TYPE,
        self::RESULT,
        self::PROMOTION_TYPE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::PREVIOUS_STD_PROMOTION_HISTORY_ID,
        self::STATUS
    ];
}