<?php

namespace App\Models\Site\Student\IDCard;

use App\Models\SiteGlobalModel;

class IdCardSetting extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table = 'site_student_id_card_settings';


    const SIGNATURE_HOLDER = 'signature_holder';
    const CARD_TEMPLATE = 'card_template';
    const SIGNATURE_TEXT = 'signature_text';
    const BG_PATH = 'bg_path';
    const BACK_BG_PATH = 'back_bg_path';
    const SITE_LOGO = 'site_logo_path';
    const STATUS = 'status';

    protected $fillable = [
        self::SIGNATURE_HOLDER,
        self::CARD_TEMPLATE,
        self::BG_PATH,
        self::SITE_LOGO,
        self::STATUS,
        self::BACK_BG_PATH,
    ];
    protected $ownFields = [
        self::SIGNATURE_HOLDER,
        self::CARD_TEMPLATE,
        self::BG_PATH,
        self::SITE_LOGO,
        self::STATUS,
        self::BACK_BG_PATH,
    ];

    public function scopeActive($q)
    {
        return $q->where('status', 1);
    }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class, 'history_id');
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'user_id');
    }
}
