<?php

namespace App\Models\Site\Student;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Gender\Gender;
use App\Models\Image\Photo;
use App\Models\Religion\Religion;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Shift\GlobalShiftDetail;
use App\Models\Site\Student\Attendance\GlobalLeaveDetail;
use App\Models\Site\Student\Attendance\GlobalStudentAbsent;
use App\Models\Site\Student\Attendance\GlobalStudentAbsentDetail;
use App\Models\User\GlobalUser;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Exam\GlobalSiteGroupStudentExamRoll;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class GlobalStudentHistory extends Model
{

    protected $table = 'student_histories';
    protected $appends = array('full_name', 'student_full_roll_number','full_name_username','username');

    const USER_ID = 'user_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const SITE_BATCH_DETAIL_ID = 'site_batch_detail_id';
    const ACADEMIC_RESIDANCE_ID = 'academic_residence_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_STUDENT_CATEGORY_ID = 'academic_student_category_id';
    const ACADEMIC_STUDENT_TYPE_ID = 'academic_student_type_id';
    const ACADEMIC_STUDENT_ADMISSION_TYPE_ID = 'academic_student_admission_type_id';
    const ACADEMIC_QUATA_ID = 'academic_quata_id';
    const BOARD_REGISTRATION_NUMBER = 'board_registration_number';
    const Board_roll_number = 'board_roll_number';
    const ACADEMIC_SUBJECT_IDS = 'academic_subject_ids';
    const OPTIONAL_SUBJECT_IDS = 'optional_subject_ids';
    const COMPULSORY_SUBJECT_IDS = 'compulsory_subject_ids';
    const Selective_compulsory_subject_ids = 'selective_compulsory_subject_ids';

//    const GENERAL_MARKINGLESS_SUBJECT_IDs = 'general_markingless_subject_ids';
    const SELECTIVE_MARKINGLESS_SUBJECT_IDs = 'select1ive_markingless_subject_ids';

    const RELIGION_SUBJECT_ID = 'religion_subject_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const STUDENT_ROLL_NUMBER = 'student_roll_number';
    const REGISTRATION_NO = 'registration_no';
    const LOCAL_GUARDIAN_ID = 'local_guardian_id';
    const SITE_ID = 'site_id';
    const PREVIOUS_ACADEMIC_CLASS_ID = 'previous_academic_class_id';
    const PREVIOUS_ROLL_NO = 'previous_roll_no';
    const PREVIOUS_GPA = 'previous_gpa';
    const PREVIOUS_EXAM_MARK = 'previous_exam_mark';
    const PREVIOUS_INSTITUTE_NAME = 'previous_institute_name';
    const PREVIOUS_INSTITUTE_LOCATION = 'previous_institute_location';
    const TC_NUMBER = 'tc_number';
    const TC_DATE = 'tc_date';
    const STATUS = 'status';
    const PREVIOUS_STUDENT_HISTORY_ID = 'previous_student_history_id';


    const Ex_academic_year_id = 'ex_academic_year_id';
    const Ex_academic_shift_id = 'ex_academic_shift_id';
    const Ex_academic_class_id = 'ex_academic_class_id';
    const Ex_academic_department_id = 'ex_academic_department_id';
    const Ex_academic_class_group_id = 'ex_academic_class_group_id';
    const Ex_academic_section_id = 'ex_academic_section_id';
    const Ex_academic_session_id = 'ex_academic_session_id';
    const Ex_roll_number = 'ex_roll_number';
    const Ex_id_card_code = 'ex_id_card_code';
    const Student_roll_number_prefix = 'student_roll_number_prefix';


    const Created_by = 'created_by';
    const Updated_by = 'updated_by';
    const Student_edu_payment_status = 'student_edu_payment_status';
    const Edu_student_panel_close_status = 'edu_student_panel_close_status';


    const ACADEMIC_TRANSPORT_ID = 'academic_transport_id';
    const GENERAL_MARKINGLESS_SUBJECT_IDs = 'general_markingless_subject_ids';
    const Site_id = 'site_id';



    protected $fillable = [
        self::ACADEMIC_GROUP_ID,
        self::USER_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::ACADEMIC_TRANSPORT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::BOARD_REGISTRATION_NUMBER,
        self::ACADEMIC_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,

        self::COMPULSORY_SUBJECT_IDS,
        self::Selective_compulsory_subject_ids,
        self::RELIGION_SUBJECT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_YEAR_ID,
        self::STUDENT_ROLL_NUMBER,
        self::REGISTRATION_NO,
        self::LOCAL_GUARDIAN_ID,
        self::SITE_ID,
        self::PREVIOUS_ACADEMIC_CLASS_ID,
        self::PREVIOUS_STUDENT_HISTORY_ID,
        self::PREVIOUS_ROLL_NO,
        self::PREVIOUS_GPA,
        self::PREVIOUS_EXAM_MARK,
        self::PREVIOUS_INSTITUTE_NAME,
        self::PREVIOUS_INSTITUTE_LOCATION,
        self::TC_NUMBER,
        self::TC_DATE,
        self::STATUS,
        self::Student_edu_payment_status,
        self::Edu_student_panel_close_status,
        self::Site_id,
    ];

    public $ownFields = [
        self::USER_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::ACADEMIC_TRANSPORT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::BOARD_REGISTRATION_NUMBER,
        self::ACADEMIC_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
        self::COMPULSORY_SUBJECT_IDS,
        self::Selective_compulsory_subject_ids,
        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,
        self::RELIGION_SUBJECT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_YEAR_ID,
        self::STUDENT_ROLL_NUMBER,
        self::REGISTRATION_NO,
        self::LOCAL_GUARDIAN_ID,
        self::SITE_ID,
        self::PREVIOUS_ACADEMIC_CLASS_ID,
        self::PREVIOUS_ROLL_NO,
        self::PREVIOUS_GPA,
        self::PREVIOUS_EXAM_MARK,
        self::PREVIOUS_INSTITUTE_NAME,
        self::PREVIOUS_INSTITUTE_LOCATION,
        self::TC_NUMBER,
        self::TC_DATE,
        self::STATUS,
        self::Student_edu_payment_status,
        self::Site_id,
    ];

    //mutator
    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->student->first_name ?? '') . ' ' . ($this->student->last_name ?? '');
    }

    public function getStudentFullRollNumberAttribute()
    {
        return $this->attributes['student_full_roll_number'] = ($this->student_roll_number_prefix ?? '') . ($this->student_roll_number);
    }
    public function getStudentFullNameUsernameAttribute()
    {
        return $this->attributes['student_full_name_username'] = ($this->full_name ?? '') . ($this->username);
    }
    public function getFullNameUsernameAttribute()
    {
        return $this->attributes['full_name_username'] = $this->attributes['full_name'].'('. ($this->student->username ?? "").')';

    }
    public function getUsernameAttribute()
    {
        return $this->attributes['username'] = $this->student->username ?? "";

    }


    public function getAcademicSubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getOptionalSubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getCompulsorySubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }
    public function getSelectiveCompulsorySubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }


    public function getGeneralMarkinglessSubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }

    public function getSelectiveMarkinglessSubjectIdsAttribute($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }
    public function religionSubject()
    {
        return $this->belongsTo(AcademicSubject::class, 'religion_subject_id');
    }

    //scope
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    // public function student()
    // {
    //     return $this->belongsTo(GlobalUser::class, 'user_id');
    // }

    public function student()
    {
        return $this->belongsTo(Student::class, 'user_id');
    }



    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, 'academic_version_id');
    }



    public function studentShift()
    {
        return $this->belongsTo(GlobalShiftDetail::class, 'academic_shift_id','academic_shift_id');
    }

    /**
     * The roles that belong to the user.
     */
    public function subjects()
    {
        return $this->belongsToMany(AcademicSubject::class, 'student_subject', 'student_history_id')->withTimestamps();
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::ACADEMIC_DEPARTMENT_ID);
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }


    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::ACADEMIC_CLASS_GROUP_ID);
    }

    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::ACADEMIC_SESSION_ID);
    }

    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class,'academic_year_id');
    }

    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }
    public function accGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::ACADEMIC_CLASS_GROUP_ID);
    }
    public function studentType()
    {
        return $this->belongsTo(AcademicStudentType::class, 'academic_student_type_id');
    }


    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }

    public function photos()
    {
        return $this->hasMany(Photo::class, 'user_id');
    }

    public function site()
    {
        return $this->belongsTo(SiteInfo::class, 'site_id');
    }

    //methods


    public function attendance()
    {
        return $this->hasOne(GlobalStudentAttendance::class, 'student_history_id');
    }
    public function attendances()
    {
        return $this->hasMany(GlobalStudentAttendance::class, 'student_history_id');
    }

    public function presentToday()
    {
        $today = Carbon::now()->toDateString();
        return $this->hasOne(GlobalStudentAttendance::class, 'student_history_id')
            ->whereDate('present_date', $today);
    }


    public function leaveDetail()
    {
        return $this->hasOne(GlobalLeaveDetail::class, 'student_history_id');
    }

    public function absent()
    {
        return $this->hasOne(GlobalStudentAbsentDetail::class, 'student_history_id')->orderBy('id', 'DESC');
    }
    public function absents()
    {
        return $this->hasMany(GlobalStudentAbsentDetail::class, 'student_history_id')->orderBy('id', 'DESC');
    }
    public function leaveDetails()
    {
        return $this->hasMany(GlobalLeaveDetail::class, 'student_history_id');
    }

    public function siteStudentFeeDemandSlipDetails()
    {
        return $this->hasOne(GlobalSiteStudentFeeDemandSlipDetails::class, 'student_history_id');
    }

    
    public function siteGroupStudentExamRoll()
    {
        return $this->hasOne(GlobalSiteGroupStudentExamRoll::class, 'student_history_id');
    }

    public function feeDemandSlips()
    {
        return $this->hasMany(GlobalSiteStudentFeeDemandSlipDetails::class, 'student_history_id');
    }

    public function feePayments()
    {
        return $this->hasMany(GlobalSiteStudentFeePaymentHistory::class, 'student_history_id');
    }

}
