<?php

namespace App\Models\Site\Student\Attendance;

use App\Models\Edu\SMS\SmsFollowUp;
use App\Models\Site\Student\Student;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;

class StudentAbsentDetail extends SiteGlobalModel
{

    protected $table = 'site_student_attendance_absent_details';
    public $timestamps = true;

    protected $casts = [
        'sms_followup_id' => 'integer'
    ];


    const STUDENT_HISTORY_ID = 'student_history_id';
    const USER_ID = 'user_id';
    const SMS_FOLLOWUP_ID = 'sms_followup_id';
    const SMS_STATUS = 'sms_status';
    const SMS_SENT_TIME = 'sms_sent_time';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::USER_ID,
        self::SMS_FOLLOWUP_ID,
        self::SMS_SENT_TIME,
        self::SMS_STATUS,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::SMS_FOLLOWUP_ID,
        self::SMS_SENT_TIME,
        self::SMS_STATUS,
    ];


    public function student()
    {
        return $this->belongsTo(Student::class, 'user_id');
    }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class, 'student_history_id');
    }

    public function follow()
    {
        return $this->belongsTo(SmsFollowUp::class, 'sms_followup_id');
    }

}
