<?php

namespace App\Models\Site\Student\Attendance;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class GlobalStudentAbsentDetail extends Model
{

    protected $table = 'site_student_attendance_absent_details';
    public $timestamps = true;

    protected $casts = [
        'sms_followup_id' => 'integer'
    ];


    const STUDENT_HISTORY_ID = 'student_history_id';
    const USER_ID = 'user_id';
    const SMS_FOLLOWUP_ID = 'sms_followup_id';
    const SMS_STATUS = 'sms_status';
    const SMS_SENT_TIME = 'sms_sent_time';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::USER_ID,
        self::SMS_FOLLOWUP_ID,
        self::SMS_SENT_TIME,
        self::SMS_STATUS,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::SMS_FOLLOWUP_ID,
        self::SMS_SENT_TIME,
        self::SMS_STATUS,
    ];


    public function scopeAbsentToday($query)
    {
        $today_date = Carbon::now()->toDateString();
        return $query->where('absent_date', $today_date);
    }
}
