<?php

namespace App\Models\Site\Result;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Attendance\StudentAttendance;
use App\Models\ProjectModel;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class SiteStudentPrimaryResultDetail extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_student_primary_result_details';
//
//    protected $casts = [
//        'result_detail' => 'array'
//    ];

    const SITE_RESULT_PRIMARY_SETTING_ID = 'site_result_primary_setting_id';
    const STUDENT_HISTORY_ID = 'student_history_id';
    const ACADEMIC_RESULT_PRIMARY_TYPE_ID = 'academic_result_primary_type_id';
    const Site_individual_combine_subject_result_store_ids = 'site_individual_combine_subject_result_store_ids';
    const GPA = 'gpa';
    const GRADE = 'grade';
    const FAIL_SUBJECT_COUNT = 'fail_subject_count';
    const RESULT_DETAIL = 'result_detail';
    const TABLE_HEADER = 'table_header';
    const Student_rank = 'student_rank';
    const Central_rank = 'central_rank';
    const Exam_attendance_status = 'exam_attendance_status';

    const Sum_of_obtain_raw_total_marks_only_passed_subject = 'sum_of_obtain_raw_total_marks_only_passed_subject';
    const Pass_subject_base_marks_percentage = 'pass_subject_base_marks_percentage';
    const Total_marks_base_percentage = 'total_marks_base_percentage';
    const Pass_subject_base_marks_grade = 'pass_subject_base_marks_grade';
    const Total_marks_base_grade = 'total_marks_base_grade';
    const Pass_subject_base_marks_point = 'pass_subject_base_marks_point';
    const Total_marks_base_point = 'total_marks_base_point';

    const Optional_subject_ids = 'optional_subject_ids';
    const Final_point_without_optional = 'final_point_without_optional';
    const Final_grade_without_optional = 'final_grade_without_optional';
    const Combine_subject_present = 'combine_subject_present';
    const Classtest_is_present = 'classtest_is_present';

    const Sum_of_obtain_raw_total_marks = 'sum_of_obtain_raw_total_marks';
    const Sum_of_obtain_percent_total_marks = 'sum_of_obtain_percent_total_marks';
    const Sum_of_raw_total_marks = 'sum_of_raw_total_marks';
    const Raw_obtain_marks_percentage = 'raw_obtain_marks_percentage';

    const Result_employee_publish_status = 'result_employee_publish_status';
    const Result_student_publish_status = 'result_student_publish_status';
    const Result_public_publish_status = 'result_public_publish_status';
    const Result_public_full_publish_status = 'result_public_full_publish_status';

    const STATUS = 'status';

    const Sum_of_obtain_total_grade_for_show = 'sum_of_obtain_total_grade_for_show';
    const Sum_of_obtain_total_point_for_show = 'sum_of_obtain_total_point_for_show';
    const Sum_of_obtain_total_marks_for_show = 'sum_of_obtain_total_marks_for_show';
    const Sum_of_obtain_total_percent_for_show = 'sum_of_obtain_total_percent_for_show';

    const Total_student = 'total_student';
    const Academic_days = 'academic_days';
    const Comment = 'comment';
    const Comment_two = 'comment_tow';

    const Is_dynamic_attendace_count = 'is_dynamic_attendace_count';
    const Start_attendance_date_range = 'start_attendance_date_range';
    const End_attendance_date_range = 'end_attendance_date_range';

    const Present_days = 'present_days';
    const Highest_marks_list = 'highest_marks_list';

    const Absent_days = 'absent_days';
    const Behaviour = 'behaviour';
    const Cultural_activities = 'cultural_activities';
    const Bncc = 'bncc';
    const Debate = 'debate';
    const Scout = 'scout';
    const Sports = 'sports';
    const Others = 'others';

    const Punctuality = 'punctuality';
    const Obedience = 'obedience';
    const Attentiveness = 'attentiveness';
    const Classroom_behaviour = 'classroom_behaviour';
    const Commitment = 'commitment';
    const Cleanliness = 'cleanliness';
    const Handwriting = 'handwriting';
    const Homework = 'homework';
    const Classwork = 'classwork';

  //  sum_of_obtain_total_grade_for_show
  //  sum_of_obtain_total_point_for_show
  //  sum_of_obtain_total_marks_for_show

    protected $fillable = [

        self::STUDENT_HISTORY_ID,
        self::SITE_RESULT_PRIMARY_SETTING_ID,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_ID,
        self::Site_individual_combine_subject_result_store_ids,

        self::Optional_subject_ids,
        self::Final_point_without_optional,
        self::Final_grade_without_optional,
        self::Combine_subject_present,
        self::Classtest_is_present,
        self::Student_rank,
        self::Central_rank,
        self::Exam_attendance_status,

        self::Sum_of_obtain_raw_total_marks_only_passed_subject,
        self::Pass_subject_base_marks_percentage,
        self::Total_marks_base_percentage,
        self::Pass_subject_base_marks_grade,
        self::Total_marks_base_grade,
        self::Pass_subject_base_marks_point,
        self::Total_marks_base_point,

        self::Sum_of_obtain_raw_total_marks,
        self::Sum_of_obtain_percent_total_marks,
        self::Sum_of_raw_total_marks,
        self::Raw_obtain_marks_percentage,

        self::GPA,
        self::GRADE,
        self::FAIL_SUBJECT_COUNT,
        self::RESULT_DETAIL,
        self::TABLE_HEADER,
        self::STATUS,

        self::Sum_of_obtain_total_grade_for_show,
        self::Sum_of_obtain_total_point_for_show,
        self::Sum_of_obtain_total_marks_for_show,
        self::Sum_of_obtain_total_percent_for_show,

        self::Result_employee_publish_status,
        self::Result_student_publish_status,
        self::Result_public_publish_status,
        self::Result_public_full_publish_status,

        self::Total_student,
        self::Academic_days,
        self::Present_days,
        self::Highest_marks_list,
        self::Comment,
        self::Comment_two,
        self::Absent_days,
        self::Behaviour,
        self::Cultural_activities,
        self::Bncc,
        self::Debate,
        self::Scout,
        self::Sports,
        
        self::Others,
        self::Punctuality,
        self::Obedience,
        self::Attentiveness,
        self::Classroom_behaviour,
        self::Commitment,
        self::Cleanliness,
        self::Handwriting,
        self::Homework,
        self::Classwork,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::SITE_RESULT_PRIMARY_SETTING_ID,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_ID,
        self::Site_individual_combine_subject_result_store_ids,

        self::Optional_subject_ids,
        self::Final_point_without_optional,
        self::Final_grade_without_optional,
        self::Combine_subject_present,
        self::Classtest_is_present,
        self::Student_rank,
        self::Central_rank,
        self::Exam_attendance_status,


        self::Sum_of_obtain_raw_total_marks_only_passed_subject,
        self::Pass_subject_base_marks_percentage,
        self::Total_marks_base_percentage,
        self::Pass_subject_base_marks_grade,
        self::Total_marks_base_grade,
        self::Pass_subject_base_marks_point,
        self::Total_marks_base_point,

        self::Sum_of_obtain_raw_total_marks,
        self::Sum_of_obtain_percent_total_marks,
        self::Sum_of_raw_total_marks,
        self::Raw_obtain_marks_percentage,

        self::GPA,
        self::GRADE,
        self::FAIL_SUBJECT_COUNT,
        self::RESULT_DETAIL,
        self::TABLE_HEADER,
        self::STATUS,

        self::Sum_of_obtain_total_grade_for_show,
        self::Sum_of_obtain_total_point_for_show,
        self::Sum_of_obtain_total_marks_for_show,
        self::Sum_of_obtain_total_percent_for_show,
    ];


    public function getTableHeaderAttribute($values)
    {
        return $this->attributes['table_header'] =json_decode($values);

    }


    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');
    }
    public function attendances()
    {
        return $this->belongsTo(StudentAttendance::class,'student_history_id');
    }
    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class, 'academic_result_primary_type_id');
    }

    public function getSiteIndividualCombineSubjectResultStoreIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = SiteIndividualCombineSubjectResultStore::whereIn('id', $arr)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();
        return $array;

    }

}
