<?php

namespace App\Models\Site\Result;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;

use App\Models\Examinations\Examination;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteResultPrimarySetting extends SiteGlobalModel
{
    public $timestamps = false;
    protected $table='site_result_primary_settings';

    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Academic_session_id = 'academic_session_id';
    const Academic_result_primary_type_id = 'academic_result_primary_type_id';
    const Math_condition = 'math_condition';
    const Combine_subject_result_condition = 'combine_subject_result_condition';

    const Examination_id = 'examination_id';
    const Show_position = 'show_position';

    const Marks_percentage = 'marks_percentage';
    const Status = 'status';
    const Academic_group_id = 'academic_group_id';



    protected $fillable = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Examination_id,
        self::Academic_result_primary_type_id,
        self::Math_condition,
        self::Combine_subject_result_condition,
        self::Marks_percentage,
        self::Show_position,
        self::Status,
        self::Academic_group_id,
    ];

    public $ownFields = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Examination_id,
        self::Academic_result_primary_type_id,
        self::Math_condition,
        self::Combine_subject_result_condition,
        self::Marks_percentage,
        self::Show_position,
        self::Status,
        self::Academic_group_id,
    ];





    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }

    public function academicShift()
    {
        return $this->belongsTo(AcademicShift::class);
    }

    public function aademicVersion()
    {
        return $this->belongsTo(AcademicVersion::class);
    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    public function academicDepartment()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }


    public function academicClassGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class);
    }


    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class);
    }


    public function examination()
    {
        return $this->belongsTo(Examination::class);
    }

}
