<?php

namespace App\Models\Site\Result;

use App\Models\Academic\AcademicSubject;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SiteIndividualCombineSubjectResultStore extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_individual_combine_subject_result_stores';

    const Student_history_id = 'student_history_id';
    const Academic_result_primary_type_id = 'academic_result_primary_type_id';
    const Exam_dependent_academic_subject_id = 'exam_dependent_academic_subject_id';
    const Optional_academic_subject_status = 'optional_academic_subject_status';
    const Subject_result_count_status = 'subject_result_count_status';
    const Subject_base_pass_fail_status = 'subject_base_pass_fail_status';
    const Obtain_subject_total_marks = 'obtain_subject_total_marks';
    const Subject_marks_percentage = 'subject_marks_percentage';
    const Same_row_total_marks = 'same_row_total_marks';
    const Same_obtain_raw_total_marks = 'same_obtain_raw_total_marks';
    const Raw_total_marks = 'raw_total_marks';
    const Obtain_raw_total_marks = 'obtain_raw_total_marks';
    const Obtain_percent_total_marks = 'obtain_percent_total_marks';
    const Obtain_total_marks_for_show = 'obtain_total_marks_for_show';
    const List_for_tabulation = 'list_for_tabulation';
    const Subject_grade = 'subject_grade';
    const Exam_attendance_status = 'exam_attendance_status';
    const Subject_point = 'subject_point';
    const Subject_position = 'subject_position';
    const Subject_exam_condition_name_key = 'subject_exam_condition_name_key';

    const Result_show_in_table_bellow_status = 'result_show_in_table_bellow_status';

    const Created_at = 'created_at';
    const Updated_at = 'updated_at';


    const Subject_count = 'subject_count';
    const Subject_detail = 'subject_detail';
    const Status = 'status';



    protected $fillable = [
        self::Student_history_id,
        self::Academic_result_primary_type_id,
        self::Exam_dependent_academic_subject_id,
        self::Optional_academic_subject_status,
        self::Subject_base_pass_fail_status,
        self::Subject_result_count_status,
        self::Subject_count,
        self::Exam_attendance_status,
        self::Subject_detail,
        self::Same_row_total_marks,
        self::Same_obtain_raw_total_marks,
        self::Raw_total_marks,
        self::Obtain_subject_total_marks,
        self::Subject_marks_percentage,
        self::Obtain_raw_total_marks,
        self::Obtain_total_marks_for_show,
        self::List_for_tabulation,
        self::Obtain_percent_total_marks,
        self::Subject_grade,
        self::Result_show_in_table_bellow_status,
        self::Subject_point,
        self::Subject_position,
        self::Subject_exam_condition_name_key,
        self::Created_at,
        self::Updated_at,
        self::Status,
    ];

    public $ownFields = [
        self::Student_history_id,
        self::Academic_result_primary_type_id,
        self::Exam_dependent_academic_subject_id,
        self::Optional_academic_subject_status,
        self::Subject_base_pass_fail_status,
        self::Subject_result_count_status,
        self::Subject_count,
        self::Exam_attendance_status,
        self::Subject_detail,
        self::Same_row_total_marks,
        self::Same_obtain_raw_total_marks,
        self::Raw_total_marks,
        self::Obtain_subject_total_marks,
        self::List_for_tabulation,
        self::Subject_marks_percentage,
        self::Obtain_raw_total_marks,
        self::Obtain_total_marks_for_show,
        self::Obtain_percent_total_marks,
        self::Subject_grade,
        self::Result_show_in_table_bellow_status,
        self::Subject_point,
        self::Subject_position,
        self::Subject_exam_condition_name_key,
        self::Created_at,
        self::Updated_at,
        self::Status,
    ];


    public function getSubjectDetailAttribute($values)
    {
        return $this->attributes['subject_detail'] = json_decode($values);
     //   return $this->attributes['subject_detail'] = $values;
    }

    public function academicSubject()
    {
        return $this->belongsTo(AcademicSubject::class, 'exam_dependent_academic_subject_id');
    }


}
