<?php

namespace App\Models\Site\Quiz;

use Illuminate\Database\Eloquent\Model;
use Dimsav\Translatable\Translatable;
use App\Models\GroupSiteModel;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectTopic;
use App\Models\AcademicYear\AcademicYear;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use App\User;

class SiteQuizQuestionInfo extends ProjectModel
{
    public $timestamps = true;
    protected $table = 'site_exam_question_infos';
    protected $dates = ['created_at','updated_at', 'created_date'];


    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SUBJECT_ID = 'academic_subject_id';
    const ACADEMIC_SUBJECT_TOPIC_ID = 'academic_subject_topic_id';
    const ACADEMIC_EXAM_TYPE_ID = 'academic_exam_type_id';
    const WRITTEN_TYPE = 'written_type';
    const MODULE_KEY = 'module_key';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';



    protected $fillable = [

        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SUBJECT_ID,
        self::ACADEMIC_SUBJECT_TOPIC_ID,
        self::ACADEMIC_EXAM_TYPE_ID,
        self::WRITTEN_TYPE,
        self::MODULE_KEY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,

    ];

    public $ownFields = [
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SUBJECT_ID,
        self::ACADEMIC_SUBJECT_TOPIC_ID,
        self::ACADEMIC_EXAM_TYPE_ID,
     //   self::WRITTEN_TYPE,
        self::MODULE_KEY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
    ];




    public function user()
    {
        return $this->belongsTo(User::class,'id','created_by');
    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    public function academicSubject()
    {
        return $this->belongsTo(AcademicSubject::class);
    }

    public function academicDepartment()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }

    public function academicSubjectTopic()
    {
        return $this->belongsTo(AcademicSubjectTopic::class, 'academic_subject_topic_id');
    }

    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class, 'academic_exam_type_id');
    }

    public function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class);
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }
    public function quizTopic()
    {
        return $this->belongsTo(QuizTopics::class,'quiz_topic_id');
    }
    
    public function siteQuizQuestion()
    {
        return $this->hasMany(SiteQuizQuestion::class);
    }


}
