<?php

namespace App\Models\Site\Quiz;

use Illuminate\Database\Eloquent\Model;
use App\Models\ProjectModel;
use Dimsav\Translatable\Translatable;
use App\Models\GroupSiteModel;

class SiteQuizQuestion extends ProjectModel
{

    use  Translatable;
    public $translationModel = SiteQuizQuestionTranslation::class;
    public $translationForeignKey = 'site_exam_question_id';

    public $timestamps = true;
    protected $table = 'site_exam_questions';
    protected $dates = ['created_at','updated_at'];

    
    const SITE_EXAM_QUESTION_INFO_ID = 'site_exam_question_info_id';
    const MARK = 'mark';
    const QUESTION_LEVEL = 'question_level';
    const QUESTION_NO = 'question_no';
    const QUESTION = 'question';
    const MODULE_KEY= 'module_key';
    const SITE_ID = 'site_id';
    const Site_group_id = 'site_group_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';
    const QUESTION_STATUS = 'question_status';




    protected $fillable = [

        self::SITE_EXAM_QUESTION_INFO_ID,
        self::MARK,
        self::QUESTION_LEVEL,
        self::QUESTION_NO,
        self::QUESTION,
        self::MODULE_KEY,
        self::SITE_ID,
        self::Site_group_id,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::QUESTION_STATUS,

    ];

    public $translatedAttributes = [
        self::QUESTION,
    ];

    public $ownFields = [
        self::SITE_EXAM_QUESTION_INFO_ID,
        self::MARK,
        self::QUESTION_LEVEL,
        self::QUESTION_NO,
        self::QUESTION,
        self::MODULE_KEY,
        self::SITE_ID,
        self::Site_group_id,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::QUESTION_STATUS,
    ];

    
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
  
    public function siteQuizQuestionInfo()
    {
        return $this->belongsTo(SiteQuizQuestionInfo::class, 'site_exam_question_info_id');
    }

    public function siteQuizQuestionDetails()
    {
        return $this->hasMany(SiteQuizQuestionDetails::class,'site_exam_question_id');
    }

    public function siteQuizQuestionDetailList()
    {
        return $this->hasMany(SiteQuizQuestionDetails::class, 'site_exam_question_id')->select('id','site_exam_question_id', 'answer_status');

    }

    // public function photo()
    // {
    //     return $this->morphMany(Photo::class, 'imageable');

    // }

}
