<?php

namespace App\Models\Site\Permission;

use App\Models\ProjectModel;
use App\Models\Site\Role\SiteRole;

class SiteRoleAccess extends ProjectModel
{
    protected $table='site_role_accesses';
    public $timestamps = true;


    const SITE_ROLE_ID = 'site_role_id';
    const SUB_MODULE_IDS = 'sub_module_ids';
    const DASHBOARD_PALETTES = 'dashboard_palettes';



    protected $fillable = [
        self::SITE_ROLE_ID,
        self::SUB_MODULE_IDS,
        self::DASHBOARD_PALETTES,
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function role()
    {
        return $this->belongsTo(SiteRole::class,self::SITE_ROLE_ID);
    }
}
