<?php

namespace App\Models\Site\Payment;

use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentOnlinePaymentDetails extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_student_online_payment_details';


    const TRANSACTION_ID = 'transaction_id';
    const PAYMENT_GATEWAY_ID = 'payment_gateway_id';
    const SITE_STUDENT_PAYMENT_HISTORY_ID = 'site_student_payment_history_id';
    const STUDENT_HISTORY_ID = 'student_history_id';
    const TRANSACTION_AMOUNT = 'transaction_amount';
    const TRANSACTION_STATUS = 'transaction_status';
    const TRANSACTION_DATE = 'transaction_date';
    const Transaction_token = 'transaction_token';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const ORDER_ID = 'order_id';
    const PAYMENT_REF_ID = 'payment_ref_id';
    const CLIENT_MOBILE_NO = 'client_mobile_no';
    const MERCHANT_MOBILE_NO = 'merchant_mobile_no';
    const ORDER_DATE_TIME = 'order_date_time';
    const ISSUER_PAYMENT_DATE_TIME = 'issuer_payment_date_time';
    const ISSUER_PAYMENT_REF_NO = 'issuer_payment_ref_no';
    const ACADEMIC_ONLINE_PAYMENT_METHOD_ID = 'academic_online_payment_method_id';
    const PAYMENT_STATUS = 'payment_status';
    const STATUS_CODE = 'status_code';
    const TRX_ID = 'trx_id';
    const STATUS = 'status';


    protected $fillable = [
        self::TRANSACTION_ID,
        self::PAYMENT_GATEWAY_ID,
        self::SITE_STUDENT_PAYMENT_HISTORY_ID,
        self::STUDENT_HISTORY_ID,
        self::TRANSACTION_AMOUNT,
        self::TRANSACTION_STATUS,
        self::TRANSACTION_DATE,
        self::Transaction_token,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::ORDER_ID,
        self::PAYMENT_REF_ID,
        self::CLIENT_MOBILE_NO,
        self::MERCHANT_MOBILE_NO,
        self::ISSUER_PAYMENT_DATE_TIME,
        self::ISSUER_PAYMENT_REF_NO,
        self::ACADEMIC_ONLINE_PAYMENT_METHOD_ID,
        self::PAYMENT_STATUS,
        self::STATUS_CODE,
        self::TRX_ID,
        self::STATUS
    ];

    public $ownFields = [
        self::TRANSACTION_ID,
        self::PAYMENT_GATEWAY_ID,
        self::SITE_STUDENT_PAYMENT_HISTORY_ID,
        self::STUDENT_HISTORY_ID,
        self::TRANSACTION_AMOUNT,
        self::TRANSACTION_STATUS,
        self::TRANSACTION_DATE,
        self::Transaction_token,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::ORDER_ID,
        self::PAYMENT_REF_ID,
        self::CLIENT_MOBILE_NO,
        self::MERCHANT_MOBILE_NO,
        self::ISSUER_PAYMENT_DATE_TIME,
        self::ISSUER_PAYMENT_REF_NO,
        self::ACADEMIC_ONLINE_PAYMENT_METHOD_ID,
        self::PAYMENT_STATUS,
        self::STATUS_CODE,
        self::TRX_ID,
        self::STATUS
    ];

    public function siteStudentFeePaymentHistory()
    {
        return $this->belongsTo(SiteStudentFeePaymentHistory::class, 'site_student_payment_history_id');
    }
}
