<?php

namespace App\Models\Site\Live;

use App\Models\Academic\AcademicSubject;
use App\Models\Site\Routine\RoutineAllocation;
use Illuminate\Database\Eloquent\Model;

class MeetingInvitation extends Model
{
    public $timestamps = true;
    protected $table = 'site_live_meeting_invitations';


    const USER_ID = 'user_id';
    const ST_HISTORY_ID = 'st_history_id';
    const ALLOCATION_ID = 'routine_allocation_id';
    const MEETING_ID = 'meeting_id';
    const JOIN_DATE_TIME = 'join_date_time';
    const JOIN_DATE = 'join_date';
    const USER_ACTIVITIES = 'user_activities';
    const STATUS = 'status';


    protected $fillable = [
        self::JOIN_DATE_TIME,
        self::JOIN_DATE,
        self::ALLOCATION_ID,
        self::MEETING_ID,
        self::USER_ACTIVITIES,
        self::USER_ID,
        self::ST_HISTORY_ID,
        self::STATUS,
    ];


    public $ownFields = [
        self::JOIN_DATE_TIME,
        self::JOIN_DATE,
        self::ALLOCATION_ID,
        self::MEETING_ID,
        self::USER_ACTIVITIES,
        self::USER_ID,
        self::ST_HISTORY_ID,
        self::STATUS,
    ];


    public function routineAllocation()
    {
        return $this->belongsTo(RoutineAllocation::class, 'routine_allocation_id');
    }

    public function meeting()
    {
        return $this->belongsTo(Meeting::class, 'meeting_id');
    }
    public function subject()
    {
        return $this->belongsTo(AcademicSubject::class, 'subject_id');
    }


    public function scopeTodayMeeting($query, $date)
    {
        return $query->where('join_date', $date);
    }

}
