<?php

namespace App\Models\Site\Live;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class Meeting extends ProjectModel
{
    public $timestamps = true;
    protected $table = 'site_live_meetings';


    const EMAIL = 'contact_email';
    const STREAMED_BY = 'streamed_by';
    const MEETING_ID = 'meeting_id';
    const UUID = 'uuid';
    const API_TOKEN = 'host_id';
    const TOPIC = 'topic';
    const START_TIME = 'start_time';
    const START_URL = 'start_url';
    const JOIN_URL = 'join_url';
    const USER_ID = 'user_id';


    protected $fillable = [
        self::EMAIL,
        self::STREAMED_BY,
        self::MEETING_ID,
        self::UUID,
        self::TOPIC,
        self::START_TIME,
        self::START_URL,
        self::JOIN_URL,
        self::USER_ID,
    ];


    public $ownFields = [
        self::EMAIL,
        self::STREAMED_BY,
        self::MEETING_ID,
        self::UUID,
        self::TOPIC,
        self::START_TIME,
        self::START_URL,
        self::JOIN_URL,
        self::USER_ID,
    ];


    public function invitations()
    {
        return $this->hasMany(MeetingInvitation::class, 'meeting_id');
    }

}
