<?php

namespace App\Models\Site\Fee;

use App\Models\Site\Accounts\SiteAccountsVoucherDetailsStudentPaymentHistoryRecord;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\Payment\SiteStudentOnlinePaymentDetails;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeePaymentHistory extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_student_fee_payment_histories';

    const USER_ID = 'user_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STUDENT_HISTORY_ID = 'student_history_id';
    const Site_student_fee_demand_slip_details_id = 'site_student_fee_demand_slip_details_id';
    const PAYABLE_AMOUNT = 'payable_amount';
    const PAID_AMOUNT = 'paid_amount';
    const DUE_AMOUNT = 'due_amount';
    const PAYMENT_SLIP_NO = 'payment_slip_no';
    const CREATED_BY = 'created_by';
    const SITE_ID = 'site_id';
    const SITE_GROUP_ID = 'site_group_id';
    const STATUS = 'status';
    const DUE_TRANSFER_TO_PROMOTED_STUDENT_HISTORY_ID = 'due_transfer_to_promoted_student_history_id';
    const DUE_AMOUNT_ADD_TO_DEMAND_SLIP_ID = 'due_amount_add_to_demand_slip_id';
    const PAID_BY = 'paid_by';
    const PAYMENT_DATE = 'payment_date';
    const REFERENCE_NO = 'reference_no';
    const ACCOUNTS_RECEIVED_STATUS = 'accounts_received_status';
    const ACADEMIC_PAYMENT_TYPE_KEY = 'academic_payment_type_key';
    const Online_payment_status = 'online_payment_status';
    const PREVIOUS_ACADEMIC_CLASS_DUE_STATUS = 'previous_academic_class_due_status';
    const Site_payment_gateway_id = 'site_payment_gateway_id';
    const Sonali_pay_mode = 'sonali_pay_mode';
    const Sonali_pay_api_response_details = 'sonali_pay_api_response_details';
    const Account_setting_info = 'account_setting_info';
    const Credit_info = 'credit_info';
    const Transaction_id = 'transaction_id';
    const Collected_gateway = 'collected_gateway';


    protected $fillable = [
        self::USER_ID,
        self::ACADEMIC_GROUP_ID,
        self::STUDENT_HISTORY_ID,
        self::Site_student_fee_demand_slip_details_id,
        self::PAYABLE_AMOUNT,
        self::PAID_AMOUNT,
        self::DUE_AMOUNT,
        self::PAYMENT_SLIP_NO,
        self::CREATED_BY,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::STATUS,
        self::DUE_TRANSFER_TO_PROMOTED_STUDENT_HISTORY_ID,
        self::DUE_AMOUNT_ADD_TO_DEMAND_SLIP_ID,
        self::PAID_BY,
        self::PAYMENT_DATE,
        self::REFERENCE_NO,
        self::ACCOUNTS_RECEIVED_STATUS,
        self::ACADEMIC_PAYMENT_TYPE_KEY,
        self::PREVIOUS_ACADEMIC_CLASS_DUE_STATUS,
        self::Online_payment_status,
        self::Site_payment_gateway_id,
        self::Sonali_pay_mode,
        self::Sonali_pay_api_response_details,
        self::Account_setting_info,
        self::Credit_info,
        self::Transaction_id,
        self::Collected_gateway,
    ];

    public $ownFields = [
        self::USER_ID,
        self::ACADEMIC_GROUP_ID,
        self::STUDENT_HISTORY_ID,
        self::Site_student_fee_demand_slip_details_id,
        self::PAYABLE_AMOUNT,
        self::PAID_AMOUNT,
        self::DUE_AMOUNT,
        self::PAYMENT_SLIP_NO,
        self::CREATED_BY,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::STATUS,
        self::DUE_TRANSFER_TO_PROMOTED_STUDENT_HISTORY_ID,
        self::DUE_AMOUNT_ADD_TO_DEMAND_SLIP_ID,
        self::PAID_BY,
        self::PAYMENT_DATE,
        self::REFERENCE_NO,
        self::ACCOUNTS_RECEIVED_STATUS,
        self::ACADEMIC_PAYMENT_TYPE_KEY,
        self::PREVIOUS_ACADEMIC_CLASS_DUE_STATUS,
        self::Online_payment_status,
        self::Site_payment_gateway_id,
        self::Sonali_pay_mode,
        self::Sonali_pay_api_response_details,
        self::Account_setting_info,
        self::Credit_info,
        self::Transaction_id,
    ];

    public function siteStudentFeeDemandSlipDetails()
    {
        return $this->belongsTo(SiteStudentFeeDemandSlipDetails::class);
    }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);
    }

    public function siteAccountsVoucherDetailsStudentPaymentHistoryRecord()
    {
        return $this->hasOne(SiteAccountsVoucherDetailsStudentPaymentHistoryRecord::class,'site_student_fee_payment_history_id');
    }

    public function siteStudentOnlinePaymentDetails()
    {
        return $this->hasOne(SiteStudentOnlinePaymentDetails::class, 'site_student_payment_history_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function paymentGateway()
    {
        return $this->belongsTo(SitePaymentGateway::class,'site_payment_gateway_id');
    }
}
