<?php

namespace App\Models\Site\Fee;

use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeDemandSlip extends Model
{
    public $timestamps = true;
    protected $table='site_student_fee_demand_slips';

    const USER_ID = 'user_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';

    const SLIP_NO = 'slip_no';
    const DEMAND_DATE = 'demand_date';
    const TOTAL_AMOUNT = 'total_amount';
    const PREVIOUS = 'previous';

    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const ORDER_ID = 'order_id';
    const SITE_PAYMENT_GATEWAY_ID = 'site_payment_gateway_id';
    const Credit_info = 'credit_info';
    const STATUS = 'status';


    protected $fillable = [

        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SESSION_ID,

        self::SLIP_NO,
        self::DEMAND_DATE,
        self::TOTAL_AMOUNT,
        self::PREVIOUS,

        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::ORDER_ID,
        self::SITE_PAYMENT_GATEWAY_ID,
        self::Credit_info,
        self::STATUS,

    ];

    public $ownFields = [
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SESSION_ID,

        self::SLIP_NO,
        self::DEMAND_DATE,
        self::TOTAL_AMOUNT,
        self::PREVIOUS,

        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::ORDER_ID,
        self::SITE_PAYMENT_GATEWAY_ID,
        self::Credit_info,
        self::STATUS,
    ];


}