<?php

namespace App\Models\Site\Fee;

use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteStudentFeeDemandSlipDetails extends Model
{
    public $timestamps = true;
    protected $table='site_student_fee_demand_slip_details';
    protected $appends = array('slip_no');



    const Student_history_id = 'student_history_id';
    const Id = 'id';
    const Total_amount = 'total_amount';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';
    const Slip_no = 'slip_no';
    const Previous_due = 'previous_due';
    const Site_student_fee_generate_ids = 'site_student_fee_generate_ids';
    const Site_student_fee_waiver_offer_history_ids = 'site_student_fee_waiver_offer_history_ids';
    const Payment_duration = 'payment_duration';
    const Site_group_id = 'site_group_id';
    const Fee_amount = 'fee_amount';
    const Waiver_amount = 'waiver_amount';
    const Special_waiver_amount = 'special_waiver_amount';
    const Total_waiver_amount = 'total_waiver_amount';
    const Offer_amount = 'offer_amount';
    const Created_by = 'created_by';
    const Created_date = 'created_date';
    const Last_payment_date = 'last_payment_date';
    const Random_number = 'random_number';
    const Status = 'status';
    const SITE_PAYMENT_GATEWAY_ID = 'site_payment_gateway_id';
    const Due_transfer_to_promoted_student_history_id = 'due_transfer_to_promoted_student_history_id';
    const Previous_academic_class_due_status = 'previous_academic_class_due_status';
    const Previous_site_student_fee_demand_slip_detail_id = 'previous_site_student_fee_demand_slip_detail_id';
    const Transaction_token = 'transaction_token';
    const Transection_id = 'transection_id';
    const Credit_info = 'credit_info';
    const Credit_condition = 'credit_condition';
    const Payment_fine_status = 'payment_fine_status';
    const Payment_to_date = 'payment_to_date';
    const Payment_from_date = 'payment_from_date';


    protected $fillable = [

        self::Id,
        self::Student_history_id,
        self::Total_amount,
        self::Academic_group_id,
        self::Slip_no,
        self::Previous_due,
        self::Site_student_fee_generate_ids,
        self::Site_student_fee_waiver_offer_history_ids,
        self::Payment_duration,
        self::Fee_amount,
        self::Waiver_amount,
        self::Special_waiver_amount,
        self::Total_waiver_amount,
        self::Offer_amount,
        self::Created_by,
        self::Created_date,
        self::Last_payment_date,
        self::Site_id,
        self::Site_group_id,
        self::Random_number,
        self::Status,
        self::SITE_PAYMENT_GATEWAY_ID,
        self::Due_transfer_to_promoted_student_history_id,
        self::Previous_academic_class_due_status,
        self::Previous_site_student_fee_demand_slip_detail_id,
        self::Transaction_token,
        self::Transection_id,
        self::Credit_info,
        self::Credit_condition,
        self::Payment_fine_status,
        self::Payment_to_date,
        self::Payment_from_date,

    ];

    public $ownFields = [
        self::Id,
        self::Student_history_id,
        self::Total_amount,
        self::Academic_group_id,
        self::Slip_no,
        self::Previous_due,
        self::Site_student_fee_generate_ids,
        self::Site_student_fee_waiver_offer_history_ids,
        self::Payment_duration,
        self::Fee_amount,
        self::Waiver_amount,
        self::Special_waiver_amount,
        self::Offer_amount,
        self::Created_by,
        self::Created_date,
        self::Last_payment_date,
        self::Site_id,
        self::Site_group_id,
        self::Random_number,
        self::Status,
        self::SITE_PAYMENT_GATEWAY_ID,
        self::Due_transfer_to_promoted_student_history_id,
        self::Previous_site_student_fee_demand_slip_detail_id,
        self::Transaction_token,
        self::Transection_id,
        self::Credit_info,
        self::Credit_condition,
        self::Payment_fine_status,
        self::Payment_to_date,
        self::Payment_from_date,
    ];



    //mutator
    public function getSlipNoAttribute($value)
    {
        return  $this->attributes['slip_no']= $this->attributes['id']+100000;
    }

    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');

    }

    public function paymentGateway()
    {
        return $this->belongsTo(GlobalSitePaymentGateway::class,'site_payment_gateway_id');
    }

    public function siteStudentFeePaymentHistory()
    {
        return $this->hasMany(GlobalSiteStudentFeePaymentHistory::class,'site_student_fee_demand_slip_details_id');
    }

    public function siteStudentFeeFine()
    {
        return $this->hasMany(GlobalSiteStudentFeeFine::class,'site_student_fee_demand_slip_details_id');
    }
    public function createdBy()
    {
        return $this->belongsTo(GlobalUser::class,'created_by');
    }
}
