<?php

namespace App\Models\Site\ExamCommittee;

use App\Models\Employee\EmpExamCommitteePosition;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteExamCommitteeEmployeeSetting extends Model
{
    protected $table='site_exam_committee_employee_settings';


    const Site_exam_committee_setting_id = 'site_exam_committee_setting_id';
    const User_id = 'user_id';
    const Emp_exam_committee_position_id = 'emp_exam_committee_position_id';
    const Joining_date = 'joining_date';
    const Release_date = 'release_date';
    const Status = 'status';




    protected $fillable = [
        self::Site_exam_committee_setting_id,
        self::User_id,
        self::Emp_exam_committee_position_id,
        self::Joining_date,
        self::Release_date,
        self::Status,

    ];

    protected $ownFields = [
        self::Site_exam_committee_setting_id,
        self::User_id,
        self::Emp_exam_committee_position_id,
        self::Joining_date,
        self::Release_date,
        self::Status,
    ];



    public function empExamCommitteePosition()
    {
        return $this->belongsTo(EmpExamCommitteePosition::class);
    }


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
