<?php

namespace App\Models\Site\Exam;

use App\Models\Academic\AcademicQuestionLevel;
use App\Models\Image\Photo;
use App\Models\SiteGlobalModel;
use App\Models\ProjectModel;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Dimsav\Translatable\Translatable;

class SiteExamQuestion extends ProjectModel
{
    use  Translatable;
    public $translationModel = SiteExamQuestionTranslation::class;
    public $translationForeignKey = 'site_exam_question_id';

    public $timestamps = true;
    protected $table = 'site_exam_questions';
    protected $dates = ['created_at','updated_at'];


    const SITE_EXAM_QUESTION_INFO_ID = 'site_exam_question_info_id';
    const MARK = 'mark';
    const QUESTION_LEVEL = 'question_level';
    const QUESTION_NO = 'question_no';
    const QUESTION = 'question';
    const MODULE_KEY= 'module_key';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';
    const QUESTION_STATUS = 'question_status';




    protected $fillable = [

        self::SITE_EXAM_QUESTION_INFO_ID,
        self::MARK,
        self::QUESTION_LEVEL,
        self::QUESTION_NO,
        self::QUESTION,
        self::MODULE_KEY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::QUESTION_STATUS,

    ];

    public $translatedAttributes = [
        self::QUESTION,
    ];

    public $ownFields = [
        self::SITE_EXAM_QUESTION_INFO_ID,
        self::MARK,
        self::QUESTION_LEVEL,
        self::QUESTION_NO,
        self::QUESTION,
        self::MODULE_KEY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::QUESTION_STATUS,
    ];



    public function user()
    {
        return $this->belongsTo(User::class, 'faculty_id');
    }

    public function siteExamQuestionInfo()
    {
        return $this->belongsTo(SiteExamQuestionInfo::class, 'site_exam_question_info_id');
    }

    public function siteExamQuestionDetails()
    {
        return $this->hasMany(SiteExamQuestionDetails::class);
    }
    public function siteExamQuestionDetailsForStudent()
    {
        return $this->hasMany(SiteExamQuestionDetails::class, 'site_exam_question_id')->select('id','site_exam_question_id');
    }
    public function answer()
    {
        return $this->hasMany(SiteExamQuestionDetails::class, 'site_exam_question_id')->where('answer_status',true);
    }

    public function siteExamQuestionDetailList()
    {
        return $this->hasMany(SiteExamQuestionDetails::class, 'site_exam_question_id')->select('id','site_exam_question_id', 'answer_status');

    }

    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');

    }



}
