<?php

namespace App\Models\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\ProjectModel;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteExamDeclareStudent extends Model
{
    protected $table='site_exam_declare_students';
    protected $appends = array('student_roll_number');

    const Site_exam_declare_id = 'site_exam_declare_id';
    const Student_history_id = 'student_history_id';
    const Academic_exam_type_ids = 'academic_exam_type_ids';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::Site_exam_declare_id,
        self::Student_history_id,
        self::Academic_exam_type_ids,
        self::Site_id,
        self::Status,

    ];

    protected $ownFields = [
        self::Site_exam_declare_id,
        self::Student_history_id,
        self::Academic_exam_type_ids,
        self::Site_id,
        self::Status,
    ];

    public function getStudentRollNumberAttribute()
    {
        return $this->attributes['student_roll_number'] = $this->studentHistory->student_roll_number ?? '';
    }

    public function getAcademicExamTypeIdsAttribute($values)
    {
        return $this->attributes['academic_exam_type_ids'] = AcademicExamType::whereIn('id', explode(',', $values))->get();

    }

    public function globalSiteExamDeclareStudentSubject()
    {
        return $this->hasMany(GlobalSiteExamDeclareStudentSubject::class,'site_exam_declare_student_id');

    }
    // public function countTotal()
    // {
    //     return $this->hasMany(SiteExamDeclareStudentSubject::class)->count();
    //     return $this->hasMany(SiteExamDeclareStudentSubject::class);//->sum('countable_obtaine_marks');

    // }

    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');

    }



}
