<?php

namespace App\Models\Site\Employee;

use App\Models\Academic\AcademicShift;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;

class SiteEmployeeSiteShift extends SiteGlobalModel
{
    protected $table='site_employee_site_shifts';


    const User_id = 'user_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_group_id = 'academic_group_id';
    const In_time_grace = 'in_time_grace';
    const Out_time_grace = 'out_time_grace';
    const Assign_date = 'assign_date';
    const Release_date = 'release_date';
    const Flaxibility_present = 'flaxibility_present';
    const Status = 'status';




    public $timestamps = true;


    protected $fillable = [
        self::User_id,
        self::Academic_group_id,
        self::Academic_shift_id,
        self::In_time_grace,
        self::Out_time_grace,
        self::Assign_date,
        self::Release_date,
        self::Flaxibility_present,
        self::Status,
    ];


    protected $ownFields = [
        self::User_id,
        self::Academic_group_id,
        self::Academic_shift_id,
        self::In_time_grace,
        self::Out_time_grace,
        self::Assign_date,
        self::Release_date,
        self::Flaxibility_present,
        self::Status,
    ];


    public function shift()
    {
        return $this->belongsTo(AcademicShift::class,'academic_shift_id');
    }
}
