<?php

namespace App\Models\Site\Employee\IDCard;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class EmployeeIdCardSetting extends Model
{
    public $timestamps = true;
    protected $table = 'site_employee_id_card_settings';


    const SIGNATURE_HOLDER = 'signature_holder';
    const CARD_TEMPLATE = 'card_template';
    const SIGNATURE_TEXT = 'signature_text';
    const BG_PATH = 'bg_path';
    const SITE_LOGO = 'site_logo_path';
    const STATUS = 'status';

    protected $fillable = [
        self::SIGNATURE_HOLDER,
        self::CARD_TEMPLATE,
        self::BG_PATH,
        self::SITE_LOGO,
        self::STATUS,
    ];
    protected $ownFields = [
        self::SIGNATURE_HOLDER,
        self::CARD_TEMPLATE,
        self::BG_PATH,
        self::SITE_LOGO,
        self::STATUS,
    ];
    public function newQuery()
    {
        $site_id = (int)session()->get('SITE_ID');
        $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');

        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.site_id', $site_id);

        return $final;
    }

    public function scopeActive($q)
    {
        return $q->where('status', 1);
    }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class, 'history_id');
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'user_id');
    }
}
