<?php

namespace App\Models\Site\Batch;

use Illuminate\Database\Eloquent\Model;
use App\Models\Edu\WeekdayName;

class GlobalBatchDetail extends Model
{
    protected $table = 'site_batch_details';
    public $timestamps = true;
    protected $casts = [
        'status' => 'integer'
    ];


    const NAME = 'batch_name';
    const DESCRIPTION = 'batch_description';
    const CODE = 'batch_code';
    const START_DATE = 'start_date';
    const END_DATE = 'end_date';
    const START_TIME = 'start_time';
    const END_TIME = 'end_time';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const EDU_WEEKDAY_NAME_IDs = 'edu_weekday_name_ids';
    const SITE_ID = 'site_id';
    const STATUS = 'status';


    protected $fillable = [
        self::NAME,
        self::DESCRIPTION,
        self::CODE,
        self::START_DATE,
        self::END_DATE,
        self::START_TIME,
        self::END_TIME,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SESSION_ID,
        self::EDU_WEEKDAY_NAME_IDs,
        self::SITE_ID,


        self::STATUS,

    ];

    public $ownFields = [
        self::NAME,
        self::DESCRIPTION,
        self::CODE,
        self::START_DATE,
        self::END_DATE,
        self::START_TIME,
        self::END_TIME,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SESSION_ID,
        self::EDU_WEEKDAY_NAME_IDs,
        self::STATUS,
    ];


    public function getEduWeekdayNameIdsAttribute($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = WeekdayName::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }



}
