<?php

namespace App\Models\Site\AssessmentResult;

use App\Models\Academic\AcademicAssessmentScale;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAssessmentResultScaleSystemSetting extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_assessment_result_scale_system_settings';

    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_session_id = 'academic_session_id';
    const Academic_assessment_scale_id = 'academic_assessment_scale_id';
    const Level_from = 'level_from';
    const Level_to = 'level_to';
    const Graph_level = 'graph_level';
    const Pass_fail_status = 'pass_fail_status';
    const Academic_group_id = 'academic_group_id';
    const Site_id = 'site_id';
    const Status = 'status';

    protected $fillable = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_group_id,
        self::Academic_session_id,
        self::Academic_assessment_scale_id,
        self::Level_from,
        self::Level_to,
        self::Graph_level,
        self::Pass_fail_status,
        self::Site_id,
        self::Status,
    ];

    public $ownFields = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_group_id,
        self::Academic_session_id,
        self::Academic_assessment_scale_id,
        self::Level_from,
        self::Level_to,
        self::Graph_level,
        self::Pass_fail_status,
        self::Site_id,
        self::Status,
    ];


    public function academicResultSystem()
    {
        return $this->belongsTo(AcademicAssessmentScale::class);
    }

}
